/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cluster.lock;

import java.util.Date;
import java.util.Set;
import org.apache.camel.util.ObjectHelper;

public class LeaderInfo {
    private String groupName;
    private String leader;
    private Date localTimestamp;
    private Set<String> members;
    private Integer leaseDurationSeconds;

    public LeaderInfo() {
    }

    public LeaderInfo(String groupName, String leader, Date timestamp, Set<String> members, Integer leaseDurationSeconds) {
        this.groupName = groupName;
        this.leader = leader;
        this.localTimestamp = timestamp;
        this.members = members;
        this.leaseDurationSeconds = leaseDurationSeconds;
    }

    public boolean hasEmptyLeader() {
        return this.leader == null;
    }

    public boolean hasValidLeader() {
        return this.leader != null && this.members.contains(this.leader);
    }

    public boolean isValidLeader(String pod) {
        ObjectHelper.notNull(pod, "pod");
        return this.hasValidLeader() && pod.equals(this.leader);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getLeader() {
        return this.leader;
    }

    public void setLeader(String leader) {
        this.leader = leader;
    }

    public Date getLocalTimestamp() {
        return this.localTimestamp;
    }

    public void setLocalTimestamp(Date localTimestamp) {
        this.localTimestamp = localTimestamp;
    }

    public Set<String> getMembers() {
        return this.members;
    }

    public void setMembers(Set<String> members) {
        this.members = members;
    }

    public Integer getLeaseDurationSeconds() {
        return this.leaseDurationSeconds;
    }

    public void setLeaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds = leaseDurationSeconds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LeaderInfo{");
        sb.append("groupName='").append(this.groupName).append('\'');
        sb.append(", leader='").append(this.leader).append('\'');
        sb.append(", localTimestamp=").append(this.localTimestamp);
        sb.append(", members=").append(this.members);
        sb.append(", leaseDurationSeconds=").append(this.leaseDurationSeconds);
        sb.append('}');
        return sb.toString();
    }
}

