/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.config_maps;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesConfigMapsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesConfigMapsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private ConfigMapsConsumerTask configMapWatcher;

    public KubernetesConfigMapsConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.processor = processor;
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.configMapWatcher = new ConfigMapsConsumerTask();
        this.executor.submit(this.configMapWatcher);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes ConfigMap Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.configMapWatcher, this.configMapWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class ConfigMapsConsumerTask
    implements Runnable {
        private Watch watch;

        ConfigMapsConsumerTask() {
        }

        @Override
        public void run() {
            Watchable w = null;
            if (ObjectHelper.isNotEmpty(KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty(KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w = (FilterWatchListDeletable)KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesClient().configMaps().withLabel(KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            if (ObjectHelper.isNotEmpty(KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName())) {
                Resource configMapResource = (Resource)KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesClient().configMaps().withName(KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName());
                w = (FilterWatchListDeletable)((Object)configMapResource);
            }
            if (w == null) {
                throw new RuntimeCamelException("Consumer label key or consumer resource name need to be set.");
            }
            this.watch = w.watch(new Watcher<ConfigMap>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void eventReceived(Watcher.Action action, ConfigMap resource) {
                    Exchange exchange = KubernetesConfigMapsConsumer.this.createExchange(false);
                    exchange.getIn().setBody(resource);
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)action);
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", System.currentTimeMillis());
                    try {
                        KubernetesConfigMapsConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesConfigMapsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, e);
                    }
                    finally {
                        KubernetesConfigMapsConsumer.this.releaseExchange(exchange, false);
                    }
                }

                @Override
                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

