/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.hpa;

import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesHPAConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesHPAConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private HpaConsumerTask hpasWatcher;

    public KubernetesHPAConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.processor = processor;
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.hpasWatcher = new HpaConsumerTask();
        this.executor.submit(this.hpasWatcher);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes HPA Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.hpasWatcher, this.hpasWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class HpaConsumerTask
    implements Runnable {
        private Watch watch;

        HpaConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation<HorizontalPodAutoscaler, HorizontalPodAutoscalerList, Resource<HorizontalPodAutoscaler>> w = KubernetesHPAConsumer.this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers();
            ObjectHelper.ifNotEmpty(KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace(), w::inNamespace);
            if (ObjectHelper.isNotEmpty(KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty(KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            ObjectHelper.ifNotEmpty(KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName(), w::withName);
            this.watch = w.watch(new Watcher<HorizontalPodAutoscaler>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void eventReceived(Watcher.Action action, HorizontalPodAutoscaler resource) {
                    Exchange exchange = KubernetesHPAConsumer.this.createExchange(false);
                    exchange.getIn().setBody(resource);
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)action);
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", System.currentTimeMillis());
                    try {
                        KubernetesHPAConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesHPAConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, e);
                    }
                    finally {
                        KubernetesHPAConsumer.this.releaseExchange(exchange, false);
                    }
                }

                @Override
                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

