/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.services;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesServicesConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesServicesConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private ServicesConsumerTask servicesWatcher;

    public KubernetesServicesConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.processor = processor;
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.servicesWatcher = new ServicesConsumerTask();
        this.executor.submit(this.servicesWatcher);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Services Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.servicesWatcher, this.servicesWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class ServicesConsumerTask
    implements Runnable {
        private Watch watch;

        ServicesConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation<Service, ServiceList, ServiceResource<Service>> w = KubernetesServicesConsumer.this.getEndpoint().getKubernetesClient().services();
            ObjectHelper.ifNotEmpty(KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace(), w::inNamespace);
            if (ObjectHelper.isNotEmpty(KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty(KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            ObjectHelper.ifNotEmpty(KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName(), w::withName);
            this.watch = w.watch(new Watcher<Service>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void eventReceived(Watcher.Action action, Service resource) {
                    Exchange exchange = KubernetesServicesConsumer.this.createExchange(false);
                    exchange.getIn().setBody(resource);
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)action);
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", System.currentTimeMillis());
                    try {
                        KubernetesServicesConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesServicesConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, e);
                    }
                    finally {
                        KubernetesServicesConsumer.this.releaseExchange(exchange, false);
                    }
                }

                @Override
                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

