/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.memory.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import dev.langchain4j.store.memory.chat.InMemoryChatMemoryStore;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenWindowChatMemory
implements ChatMemory {
    private static final Logger log = LoggerFactory.getLogger(TokenWindowChatMemory.class);
    private final Object id;
    private final Integer maxTokens;
    private final Tokenizer tokenizer;
    private final ChatMemoryStore store;

    private TokenWindowChatMemory(Builder builder) {
        this.id = ValidationUtils.ensureNotNull(builder.id, "id");
        this.maxTokens = ValidationUtils.ensureGreaterThanZero(builder.maxTokens, "maxTokens");
        this.tokenizer = ValidationUtils.ensureNotNull(builder.tokenizer, "tokenizer");
        this.store = ValidationUtils.ensureNotNull(builder.store, "store");
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public void add(ChatMessage message) {
        Optional<SystemMessage> maybeSystemMessage;
        List<ChatMessage> messages = this.messages();
        if (message instanceof SystemMessage && (maybeSystemMessage = TokenWindowChatMemory.findSystemMessage(messages)).isPresent()) {
            if (maybeSystemMessage.get().equals(message)) {
                return;
            }
            messages.remove(maybeSystemMessage.get());
        }
        messages.add(message);
        TokenWindowChatMemory.ensureCapacity(messages, this.maxTokens, this.tokenizer);
        this.store.updateMessages(this.id, messages);
    }

    private static Optional<SystemMessage> findSystemMessage(List<ChatMessage> messages) {
        return messages.stream().filter(message -> message instanceof SystemMessage).map(message -> (SystemMessage)message).findAny();
    }

    @Override
    public List<ChatMessage> messages() {
        LinkedList<ChatMessage> messages = new LinkedList<ChatMessage>(this.store.getMessages(this.id));
        TokenWindowChatMemory.ensureCapacity(messages, this.maxTokens, this.tokenizer);
        return messages;
    }

    private static void ensureCapacity(List<ChatMessage> messages, int maxTokens, Tokenizer tokenizer) {
        int currentTokenCount = tokenizer.estimateTokenCountInMessages(messages);
        while (currentTokenCount > maxTokens) {
            int messageToEvictIndex = 0;
            if (messages.get(0) instanceof SystemMessage) {
                messageToEvictIndex = 1;
            }
            ChatMessage evictedMessage = messages.remove(messageToEvictIndex);
            int tokenCountOfEvictedMessage = tokenizer.estimateTokenCountInMessage(evictedMessage);
            log.trace("Evicting the following message ({} tokens) to comply with the capacity requirement: {}", (Object)tokenCountOfEvictedMessage, (Object)evictedMessage);
            currentTokenCount -= tokenCountOfEvictedMessage;
            if (!(evictedMessage instanceof AiMessage) || !((AiMessage)evictedMessage).hasToolExecutionRequests()) continue;
            while (messages.size() > messageToEvictIndex && messages.get(messageToEvictIndex) instanceof ToolExecutionResultMessage) {
                ChatMessage orphanToolExecutionResultMessage = messages.remove(messageToEvictIndex);
                log.trace("Evicting orphan {}", (Object)orphanToolExecutionResultMessage);
                currentTokenCount -= tokenizer.estimateTokenCountInMessage(orphanToolExecutionResultMessage);
            }
        }
    }

    @Override
    public void clear() {
        this.store.deleteMessages(this.id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TokenWindowChatMemory withMaxTokens(int maxTokens, Tokenizer tokenizer) {
        return TokenWindowChatMemory.builder().maxTokens(maxTokens, tokenizer).build();
    }

    public static class Builder {
        private Object id = "default";
        private Integer maxTokens;
        private Tokenizer tokenizer;
        private ChatMemoryStore store = new InMemoryChatMemoryStore();

        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        public Builder maxTokens(Integer maxTokens, Tokenizer tokenizer) {
            this.maxTokens = maxTokens;
            this.tokenizer = tokenizer;
            return this;
        }

        public Builder chatMemoryStore(ChatMemoryStore store) {
            this.store = store;
            return this;
        }

        public TokenWindowChatMemory build() {
            return new TokenWindowChatMemory(this);
        }
    }
}

