/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.ai4j.openai4j.completion.CompletionResponse;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.language.StreamingLanguageModel;
import dev.langchain4j.model.language.TokenCountEstimator;
import dev.langchain4j.model.openai.OpenAiLanguageModelName;
import dev.langchain4j.model.openai.OpenAiStreamingResponseBuilder;
import dev.langchain4j.model.openai.OpenAiTokenizer;
import dev.langchain4j.model.openai.spi.OpenAiStreamingLanguageModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;

public class OpenAiStreamingLanguageModel
implements StreamingLanguageModel,
TokenCountEstimator {
    private final OpenAiClient client;
    private final String modelName;
    private final Double temperature;
    private final Tokenizer tokenizer;

    public OpenAiStreamingLanguageModel(String baseUrl, String apiKey, String organizationId, String modelName, Double temperature, Duration timeout2, Proxy proxy, Boolean logRequests, Boolean logResponses, Tokenizer tokenizer, Map<String, String> customHeaders) {
        timeout2 = Utils.getOrDefault(timeout2, Duration.ofSeconds(60L));
        this.client = ((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)OpenAiClient.builder().baseUrl(Utils.getOrDefault(baseUrl, "https://api.openai.com/v1"))).openAiApiKey(apiKey)).organizationId(organizationId)).callTimeout(timeout2)).connectTimeout(timeout2)).readTimeout(timeout2)).writeTimeout(timeout2)).proxy(proxy)).logRequests(logRequests)).logStreamingResponses(logResponses)).userAgent("langchain4j-openai")).customHeaders(customHeaders)).build();
        this.modelName = Utils.getOrDefault(modelName, "gpt-3.5-turbo-instruct");
        this.temperature = Utils.getOrDefault(temperature, 0.7);
        this.tokenizer = Utils.getOrDefault(tokenizer, OpenAiTokenizer::new);
    }

    public String modelName() {
        return this.modelName;
    }

    @Override
    public void generate(String prompt, StreamingResponseHandler<String> handler) {
        CompletionRequest request = CompletionRequest.builder().model(this.modelName).prompt(prompt).temperature(this.temperature).build();
        int inputTokenCount = this.tokenizer.estimateTokenCountInText(prompt);
        OpenAiStreamingResponseBuilder responseBuilder = new OpenAiStreamingResponseBuilder(inputTokenCount);
        this.client.completion(request).onPartialResponse(partialResponse -> {
            responseBuilder.append((CompletionResponse)partialResponse);
            String token = partialResponse.text();
            if (token != null) {
                handler.onNext(token);
            }
        }).onComplete(() -> {
            Response<AiMessage> response = responseBuilder.build(this.tokenizer, false);
            handler.onComplete(Response.from(response.content().text(), response.tokenUsage(), response.finishReason()));
        }).onError(handler::onError).execute();
    }

    @Override
    public int estimateTokenCount(String prompt) {
        return this.tokenizer.estimateTokenCountInText(prompt);
    }

    public static OpenAiStreamingLanguageModel withApiKey(String apiKey) {
        return OpenAiStreamingLanguageModel.builder().apiKey(apiKey).build();
    }

    public static OpenAiStreamingLanguageModelBuilder builder() {
        Iterator<OpenAiStreamingLanguageModelBuilderFactory> iterator2 = ServiceHelper.loadFactories(OpenAiStreamingLanguageModelBuilderFactory.class).iterator();
        if (iterator2.hasNext()) {
            OpenAiStreamingLanguageModelBuilderFactory factory2 = iterator2.next();
            return (OpenAiStreamingLanguageModelBuilder)factory2.get();
        }
        return new OpenAiStreamingLanguageModelBuilder();
    }

    public static class OpenAiStreamingLanguageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String organizationId;
        private String modelName;
        private Double temperature;
        private Duration timeout;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Tokenizer tokenizer;
        private Map<String, String> customHeaders;

        public OpenAiStreamingLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder modelName(OpenAiLanguageModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder timeout(Duration timeout2) {
            this.timeout = timeout2;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OpenAiStreamingLanguageModel build() {
            return new OpenAiStreamingLanguageModel(this.baseUrl, this.apiKey, this.organizationId, this.modelName, this.temperature, this.timeout, this.proxy, this.logRequests, this.logResponses, this.tokenizer, this.customHeaders);
        }

        public String toString() {
            return "OpenAiStreamingLanguageModel.OpenAiStreamingLanguageModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", organizationId=" + this.organizationId + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", timeout=" + this.timeout + ", proxy=" + this.proxy + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", tokenizer=" + this.tokenizer + ", customHeaders=" + this.customHeaders + ")";
        }
    }
}

