/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class AiServiceContext {
    private static final Function<Object, Optional<String>> DEFAULT_MESSAGE_PROVIDER = x -> Optional.empty();
    public final Class<?> aiServiceClass;
    public ChatLanguageModel chatModel;
    public StreamingChatLanguageModel streamingChatModel;
    public Map<Object, ChatMemory> chatMemories;
    public ChatMemoryProvider chatMemoryProvider;
    public ModerationModel moderationModel;
    public List<ToolSpecification> toolSpecifications;
    public Map<String, ToolExecutor> toolExecutors;
    public RetrievalAugmentor retrievalAugmentor;
    public Function<Object, Optional<String>> systemMessageProvider = DEFAULT_MESSAGE_PROVIDER;

    public AiServiceContext(Class<?> aiServiceClass) {
        this.aiServiceClass = aiServiceClass;
    }

    public boolean hasChatMemory() {
        return this.chatMemories != null;
    }

    public ChatMemory chatMemory(Object memoryId) {
        return this.chatMemories.computeIfAbsent(memoryId, ignored -> this.chatMemoryProvider.get(memoryId));
    }
}

