/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AiServiceStreamingResponseHandler
implements StreamingResponseHandler<AiMessage> {
    private final Logger log = LoggerFactory.getLogger(AiServiceStreamingResponseHandler.class);
    private final AiServiceContext context;
    private final Object memoryId;
    private final Consumer<String> tokenHandler;
    private final Consumer<Response<AiMessage>> completionHandler;
    private final Consumer<Throwable> errorHandler;
    private final List<ChatMessage> temporaryMemory;
    private final TokenUsage tokenUsage;

    AiServiceStreamingResponseHandler(AiServiceContext context, Object memoryId, Consumer<String> tokenHandler, Consumer<Response<AiMessage>> completionHandler, Consumer<Throwable> errorHandler, List<ChatMessage> temporaryMemory, TokenUsage tokenUsage) {
        this.context = ValidationUtils.ensureNotNull(context, "context");
        this.memoryId = ValidationUtils.ensureNotNull(memoryId, "memoryId");
        this.tokenHandler = ValidationUtils.ensureNotNull(tokenHandler, "tokenHandler");
        this.completionHandler = completionHandler;
        this.errorHandler = errorHandler;
        this.temporaryMemory = new ArrayList<ChatMessage>(temporaryMemory);
        this.tokenUsage = ValidationUtils.ensureNotNull(tokenUsage, "tokenUsage");
    }

    @Override
    public void onNext(String token) {
        this.tokenHandler.accept(token);
    }

    @Override
    public void onComplete(Response<AiMessage> response) {
        AiMessage aiMessage = response.content();
        this.addToMemory(aiMessage);
        if (aiMessage.hasToolExecutionRequests()) {
            for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                ToolExecutor toolExecutor = this.context.toolExecutors.get(toolExecutionRequest.name());
                String toolExecutionResult = toolExecutor.execute(toolExecutionRequest, this.memoryId);
                ToolExecutionResultMessage toolExecutionResultMessage = ToolExecutionResultMessage.from(toolExecutionRequest, toolExecutionResult);
                this.addToMemory(toolExecutionResultMessage);
            }
            this.context.streamingChatModel.generate(this.messagesToSend(this.memoryId), this.context.toolSpecifications, (StreamingResponseHandler<AiMessage>)new AiServiceStreamingResponseHandler(this.context, this.memoryId, this.tokenHandler, this.completionHandler, this.errorHandler, this.temporaryMemory, TokenUsage.sum(this.tokenUsage, response.tokenUsage())));
        } else if (this.completionHandler != null) {
            this.completionHandler.accept(Response.from(aiMessage, TokenUsage.sum(this.tokenUsage, response.tokenUsage()), response.finishReason()));
        }
    }

    private void addToMemory(ChatMessage chatMessage) {
        if (this.context.hasChatMemory()) {
            this.context.chatMemory(this.memoryId).add(chatMessage);
        } else {
            this.temporaryMemory.add(chatMessage);
        }
    }

    private List<ChatMessage> messagesToSend(Object memoryId) {
        return this.context.hasChatMemory() ? this.context.chatMemory(memoryId).messages() : this.temporaryMemory;
    }

    @Override
    public void onError(Throwable error) {
        if (this.errorHandler != null) {
            try {
                this.errorHandler.accept(error);
            }
            catch (Exception e) {
                this.log.error("While handling the following error...", error);
                this.log.error("...the following error happened", (Throwable)e);
            }
        } else {
            this.log.warn("Ignored error", error);
        }
    }
}

