/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.entitylinker;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.entitylinker.EntityLinker;
import opennlp.tools.entitylinker.EntityLinkerFactory;
import opennlp.tools.entitylinker.EntityLinkerProperties;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;

public class EntityLinkerTool
extends BasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "links an entity to an external data set";
    }

    @Override
    public void run(String[] args2) {
        if (0 == args2.length) {
            System.out.println(this.getHelp());
        } else {
            EntityLinker<?> entityLinker;
            EntityLinkerProperties properties;
            String entityType = "location";
            try {
                properties = new EntityLinkerProperties(new File(args2[0]));
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Failed to load the properties file!");
            }
            try {
                entityLinker = EntityLinkerFactory.getLinker(entityType, properties);
            }
            catch (Exception e) {
                throw new TerminateToolException(-1, "Failed to instantiate the Entity Linker: " + e.getMessage());
            }
            PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "sent");
            perfMon.start();
            try (PlainTextByLineStream untokenizedLineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());){
                String line;
                ArrayList<NameSample> document = new ArrayList<NameSample>();
                while ((line = (String)untokenizedLineStream.read()) != null) {
                    if (line.trim().isEmpty()) {
                        StringBuilder text = new StringBuilder();
                        Span[] sentences = new Span[document.size()];
                        Span[][] tokensBySentence = new Span[document.size()][];
                        Span[][] namesBySentence = new Span[document.size()][];
                        for (int i = 0; i < document.size(); ++i) {
                            NameSample sample = (NameSample)document.get(i);
                            namesBySentence[i] = sample.getNames();
                            int sentenceBegin = text.length();
                            Span[] tokens = new Span[sample.getSentence().length];
                            for (int ti = 0; ti < sample.getSentence().length; ++ti) {
                                int tokenBegin = text.length();
                                text.append(sample.getSentence()[ti]);
                                text.append(" ");
                                tokens[ti] = new Span(tokenBegin, text.length());
                            }
                            tokensBySentence[i] = tokens;
                            sentences[i] = new Span(sentenceBegin, text.length());
                            text.append("\n");
                        }
                        List<?> linkedSpans = entityLinker.find(text.toString(), sentences, tokensBySentence, namesBySentence);
                        for (Span linkedSpan : linkedSpans) {
                            System.out.println(linkedSpan);
                        }
                        perfMon.incrementCounter(document.size());
                        document.clear();
                        continue;
                    }
                    document.add(NameSample.parse(line, false));
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < sentences";
    }
}

