/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import opennlp.tools.doccat.DoccatFactory;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.BaseModel;

public class DoccatModel
extends BaseModel {
    private static final String COMPONENT_NAME = "DocumentCategorizerME";
    private static final String DOCCAT_MODEL_ENTRY_NAME = "doccat.model";

    public DoccatModel(String languageCode, MaxentModel doccatModel, Map<String, String> manifestInfoEntries, DoccatFactory factory2) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, factory2);
        this.artifactMap.put(DOCCAT_MODEL_ENTRY_NAME, doccatModel);
        this.checkArtifactMap();
    }

    public DoccatModel(InputStream in) throws IOException {
        super(COMPONENT_NAME, in);
    }

    public DoccatModel(File modelFile) throws IOException {
        super(COMPONENT_NAME, modelFile);
    }

    public DoccatModel(Path modelPath) throws IOException {
        this(modelPath.toFile());
    }

    public DoccatModel(URL modelURL) throws IOException {
        super(COMPONENT_NAME, modelURL);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(DOCCAT_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Doccat model is incomplete!");
        }
    }

    public DoccatFactory getFactory() {
        return (DoccatFactory)this.toolFactory;
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return DoccatFactory.class;
    }

    public MaxentModel getMaxentModel() {
        return (MaxentModel)this.artifactMap.get(DOCCAT_MODEL_ENTRY_NAME);
    }
}

