/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.irishsentencebank;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import opennlp.tools.formats.irishsentencebank.IrishSentenceBankDocument;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

class IrishSentenceBankSentenceStream
implements ObjectStream<SentenceSample> {
    private final IrishSentenceBankDocument source;
    private Iterator<IrishSentenceBankDocument.IrishSentenceBankSentence> sentenceIt;

    IrishSentenceBankSentenceStream(IrishSentenceBankDocument source2) {
        this.source = source2;
        this.reset();
    }

    @Override
    public SentenceSample read() throws IOException {
        StringBuilder sentencesString = new StringBuilder();
        LinkedList<Span> sentenceSpans = new LinkedList<Span>();
        while (this.sentenceIt.hasNext()) {
            IrishSentenceBankDocument.IrishSentenceBankSentence sentence = this.sentenceIt.next();
            int begin = sentencesString.length();
            if (sentence.getOriginal() != null) {
                sentencesString.append(sentence.getOriginal());
            }
            sentenceSpans.add(new Span(begin, sentencesString.length()));
            sentencesString.append(' ');
        }
        if (sentenceSpans.size() == 0) {
            return null;
        }
        return new SentenceSample(sentencesString.toString(), sentenceSpans.toArray(new Span[sentenceSpans.size()]));
    }

    @Override
    public void reset() {
        this.sentenceIt = this.source.getSentences().iterator();
    }
}

