/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.lemmatizer.Lemmatizer;

public class DictionaryLemmatizer
implements Lemmatizer {
    private final Map<List<String>, List<String>> dictMap = new HashMap<List<String>, List<String>>();

    public DictionaryLemmatizer(InputStream dictionary) throws IOException {
        this.init(dictionary);
    }

    public DictionaryLemmatizer(File dictionaryFile) throws IOException {
        try (FileInputStream in = new FileInputStream(dictionaryFile);){
            this.init(in);
        }
    }

    public DictionaryLemmatizer(Path dictionaryFile) throws IOException {
        this(dictionaryFile.toFile());
    }

    private void init(InputStream dictionary) throws IOException {
        String line;
        BufferedReader breader = new BufferedReader(new InputStreamReader(dictionary));
        while ((line = breader.readLine()) != null) {
            String[] elems = line.split("\t");
            String[] lemmas = elems[2].split("#");
            this.dictMap.put(Arrays.asList(elems[0], elems[1]), Arrays.asList(lemmas));
        }
    }

    public Map<List<String>, List<String>> getDictMap() {
        return this.dictMap;
    }

    private List<String> getDictKeys(String word, String postag) {
        ArrayList<String> keys2 = new ArrayList<String>(Arrays.asList(word.toLowerCase(), postag));
        return keys2;
    }

    @Override
    public String[] lemmatize(String[] tokens, String[] postags) {
        ArrayList<String> lemmas = new ArrayList<String>();
        for (int i = 0; i < tokens.length; ++i) {
            lemmas.add(this.lemmatize(tokens[i], postags[i]));
        }
        return lemmas.toArray(new String[lemmas.size()]);
    }

    @Override
    public List<List<String>> lemmatize(List<String> tokens, List<String> posTags) {
        ArrayList<List<String>> allLemmas = new ArrayList<List<String>>();
        for (int i = 0; i < tokens.size(); ++i) {
            allLemmas.add(this.getAllLemmas(tokens.get(i), posTags.get(i)));
        }
        return allLemmas;
    }

    private String lemmatize(String word, String postag) {
        List<String> keys2 = this.getDictKeys(word, postag);
        List<String> keyValues = this.dictMap.get(keys2);
        String lemma = keyValues != null && !keyValues.isEmpty() ? keyValues.get(0) : "O";
        return lemma;
    }

    private List<String> getAllLemmas(String word, String postag) {
        ArrayList<String> lemmasList = new ArrayList<String>();
        List<String> keys2 = this.getDictKeys(word, postag);
        List<String> keyValues = this.dictMap.get(keys2);
        if (keyValues != null && !keyValues.isEmpty()) {
            lemmasList.addAll(keyValues);
        } else {
            lemmasList.add("O");
        }
        return lemmasList;
    }
}

