/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.AbstractModelWriter;
import opennlp.tools.ml.model.ComparablePredicate;
import opennlp.tools.ml.model.Context;

public abstract class NaiveBayesModelWriter
extends AbstractModelWriter {
    protected Context[] PARAMS;
    protected String[] OUTCOME_LABELS;
    protected String[] PRED_LABELS;
    int numOutcomes;

    public NaiveBayesModelWriter(AbstractModel model) {
        Object[] data = model.getDataStructures();
        this.numOutcomes = model.getNumOutcomes();
        this.PARAMS = (Context[])data[0];
        Map pmap = (Map)data[1];
        this.OUTCOME_LABELS = (String[])data[2];
        this.PARAMS = new Context[pmap.size()];
        this.PRED_LABELS = new String[pmap.size()];
        int i = 0;
        for (Map.Entry pred : pmap.entrySet()) {
            this.PRED_LABELS[i] = (String)pred.getKey();
            this.PARAMS[i] = (Context)pred.getValue();
            ++i;
        }
    }

    protected ComparablePredicate[] sortValues() {
        Object[] sortPreds = new ComparablePredicate[this.PARAMS.length];
        int numParams = 0;
        for (int pid = 0; pid < this.PARAMS.length; ++pid) {
            int[] predkeys = this.PARAMS[pid].getOutcomes();
            int numActive = predkeys.length;
            double[] activeParams = this.PARAMS[pid].getParameters();
            numParams += numActive;
            sortPreds[pid] = new ComparablePredicate(this.PRED_LABELS[pid], predkeys, activeParams);
        }
        Arrays.sort(sortPreds);
        return sortPreds;
    }

    protected List<List<ComparablePredicate>> compressOutcomes(ComparablePredicate[] sorted2) {
        ArrayList<List<ComparablePredicate>> outcomePatterns = new ArrayList<List<ComparablePredicate>>();
        if (sorted2.length > 0) {
            ComparablePredicate cp = sorted2[0];
            ArrayList<ComparablePredicate> newGroup = new ArrayList<ComparablePredicate>();
            for (int i = 0; i < sorted2.length; ++i) {
                if (cp.compareTo(sorted2[i]) == 0) {
                    newGroup.add(sorted2[i]);
                    continue;
                }
                cp = sorted2[i];
                outcomePatterns.add(newGroup);
                newGroup = new ArrayList();
                newGroup.add(sorted2[i]);
            }
            outcomePatterns.add(newGroup);
        }
        return outcomePatterns;
    }

    protected List<List<ComparablePredicate>> computeOutcomePatterns(ComparablePredicate[] sorted2) {
        ComparablePredicate cp = sorted2[0];
        ArrayList<List<ComparablePredicate>> outcomePatterns = new ArrayList<List<ComparablePredicate>>();
        ArrayList<ComparablePredicate> newGroup = new ArrayList<ComparablePredicate>();
        for (ComparablePredicate predicate : sorted2) {
            if (cp.compareTo(predicate) == 0) {
                newGroup.add(predicate);
                continue;
            }
            cp = predicate;
            outcomePatterns.add(newGroup);
            newGroup = new ArrayList();
            newGroup.add(predicate);
        }
        outcomePatterns.add(newGroup);
        System.err.println(outcomePatterns.size() + " outcome patterns");
        return outcomePatterns;
    }

    @Override
    public void persist() throws IOException {
        this.writeUTF("NaiveBayes");
        this.writeInt(this.OUTCOME_LABELS.length);
        for (String label : this.OUTCOME_LABELS) {
            this.writeUTF(label);
        }
        ComparablePredicate[] sorted2 = this.sortValues();
        List<List<ComparablePredicate>> compressed = this.computeOutcomePatterns(sorted2);
        this.writeInt(compressed.size());
        for (List<ComparablePredicate> a : compressed) {
            this.writeUTF(a.size() + a.get(0).toString());
        }
        this.writeInt(sorted2.length);
        for (ComparablePredicate s : sorted2) {
            this.writeUTF(s.name);
        }
        for (int i = 0; i < sorted2.length; ++i) {
            for (int j = 0; j < sorted2[i].params.length; ++j) {
                this.writeDouble(sorted2[i].params[j]);
            }
        }
        this.close();
    }
}

