/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import dev.ai4j.openai4j.ApiKeyHeaderInjector;
import dev.ai4j.openai4j.AuthorizationHeaderInjector;
import dev.ai4j.openai4j.GenericHeaderInjector;
import dev.ai4j.openai4j.Json;
import dev.ai4j.openai4j.OpenAiApi;
import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.PersistorConverterFactory;
import dev.ai4j.openai4j.RequestExecutor;
import dev.ai4j.openai4j.RequestLoggingInterceptor;
import dev.ai4j.openai4j.ResponseLoggingInterceptor;
import dev.ai4j.openai4j.SyncOrAsync;
import dev.ai4j.openai4j.SyncOrAsyncOrStreaming;
import dev.ai4j.openai4j.chat.ChatCompletionRequest;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.ai4j.openai4j.completion.CompletionResponse;
import dev.ai4j.openai4j.embedding.EmbeddingRequest;
import dev.ai4j.openai4j.embedding.EmbeddingResponse;
import dev.ai4j.openai4j.image.GenerateImagesRequest;
import dev.ai4j.openai4j.image.GenerateImagesResponse;
import dev.ai4j.openai4j.moderation.ModerationRequest;
import dev.ai4j.openai4j.moderation.ModerationResponse;
import dev.ai4j.openai4j.moderation.ModerationResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import okhttp3.Cache;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class DefaultOpenAiClient
extends OpenAiClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultOpenAiClient.class);
    private final String baseUrl;
    private final String apiVersion;
    private final OkHttpClient okHttpClient;
    private final OpenAiApi openAiApi;
    private final boolean logStreamingResponses;

    public DefaultOpenAiClient(String apiKey) {
        this((Builder)new Builder().openAiApiKey(apiKey));
    }

    private DefaultOpenAiClient(Builder serviceBuilder) {
        this.baseUrl = serviceBuilder.baseUrl;
        this.apiVersion = serviceBuilder.apiVersion;
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(serviceBuilder.callTimeout).connectTimeout(serviceBuilder.connectTimeout).readTimeout(serviceBuilder.readTimeout).writeTimeout(serviceBuilder.writeTimeout);
        if (serviceBuilder.openAiApiKey == null && serviceBuilder.azureApiKey == null) {
            throw new IllegalArgumentException("openAiApiKey OR azureApiKey must be defined");
        }
        if (serviceBuilder.openAiApiKey != null && serviceBuilder.azureApiKey != null) {
            throw new IllegalArgumentException("openAiApiKey AND azureApiKey cannot both be defined at the same time");
        }
        if (serviceBuilder.openAiApiKey != null) {
            okHttpClientBuilder.addInterceptor(new AuthorizationHeaderInjector(serviceBuilder.openAiApiKey));
        } else {
            okHttpClientBuilder.addInterceptor(new ApiKeyHeaderInjector(serviceBuilder.azureApiKey));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (serviceBuilder.organizationId != null) {
            headers.put("OpenAI-Organization", serviceBuilder.organizationId);
        }
        if (serviceBuilder.userAgent != null) {
            headers.put("User-Agent", serviceBuilder.userAgent);
        }
        if (serviceBuilder.customHeaders != null) {
            headers.putAll(serviceBuilder.customHeaders);
        }
        if (!headers.isEmpty()) {
            okHttpClientBuilder.addInterceptor(new GenericHeaderInjector(headers));
        }
        if (serviceBuilder.proxy != null) {
            okHttpClientBuilder.proxy(serviceBuilder.proxy);
        }
        if (serviceBuilder.logRequests) {
            okHttpClientBuilder.addInterceptor(new RequestLoggingInterceptor(serviceBuilder.logLevel));
        }
        if (serviceBuilder.logResponses) {
            okHttpClientBuilder.addInterceptor(new ResponseLoggingInterceptor(serviceBuilder.logLevel));
        }
        this.logStreamingResponses = serviceBuilder.logStreamingResponses;
        this.okHttpClient = okHttpClientBuilder.build();
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(serviceBuilder.baseUrl).client(this.okHttpClient);
        if (serviceBuilder.persistTo != null) {
            retrofitBuilder.addConverterFactory(new PersistorConverterFactory(serviceBuilder.persistTo));
        }
        retrofitBuilder.addConverterFactory(GsonConverterFactory.create(Json.GSON));
        this.openAiApi = retrofitBuilder.build().create(OpenAiApi.class);
    }

    @Override
    public void shutdown() {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
        Cache cache = this.okHttpClient.cache();
        if (cache != null) {
            try {
                cache.close();
            }
            catch (IOException e) {
                log.error("Failed to close cache", (Throwable)e);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public SyncOrAsyncOrStreaming<CompletionResponse> completion(CompletionRequest request) {
        CompletionRequest syncRequest = CompletionRequest.builder().from(request).stream(null).build();
        return new RequestExecutor<CompletionRequest, CompletionResponse, CompletionResponse>(this.openAiApi.completions(syncRequest, this.apiVersion), r -> r, this.okHttpClient, this.formatUrl("completions"), () -> CompletionRequest.builder().from(request).stream(true).build(), CompletionResponse.class, r -> r, this.logStreamingResponses);
    }

    @Override
    public SyncOrAsyncOrStreaming<String> completion(String prompt) {
        CompletionRequest request = CompletionRequest.builder().prompt(prompt).build();
        CompletionRequest syncRequest = CompletionRequest.builder().from(request).stream(null).build();
        return new RequestExecutor<CompletionRequest, CompletionResponse, String>(this.openAiApi.completions(syncRequest, this.apiVersion), CompletionResponse::text, this.okHttpClient, this.formatUrl("completions"), () -> CompletionRequest.builder().from(request).stream(true).build(), CompletionResponse.class, CompletionResponse::text, this.logStreamingResponses);
    }

    @Override
    public SyncOrAsyncOrStreaming<ChatCompletionResponse> chatCompletion(ChatCompletionRequest request) {
        ChatCompletionRequest syncRequest = ChatCompletionRequest.builder().from(request).stream(null).build();
        return new RequestExecutor<ChatCompletionRequest, ChatCompletionResponse, ChatCompletionResponse>(this.openAiApi.chatCompletions(syncRequest, this.apiVersion), r -> r, this.okHttpClient, this.formatUrl("chat/completions"), () -> ChatCompletionRequest.builder().from(request).stream(true).build(), ChatCompletionResponse.class, r -> r, this.logStreamingResponses);
    }

    @Override
    public SyncOrAsyncOrStreaming<String> chatCompletion(String userMessage) {
        ChatCompletionRequest request = ChatCompletionRequest.builder().addUserMessage(userMessage).build();
        ChatCompletionRequest syncRequest = ChatCompletionRequest.builder().from(request).stream(null).build();
        return new RequestExecutor<ChatCompletionRequest, ChatCompletionResponse, String>(this.openAiApi.chatCompletions(syncRequest, this.apiVersion), ChatCompletionResponse::content, this.okHttpClient, this.formatUrl("chat/completions"), () -> ChatCompletionRequest.builder().from(request).stream(true).build(), ChatCompletionResponse.class, r -> r.choices().get(0).delta().content(), this.logStreamingResponses);
    }

    @Override
    public SyncOrAsync<EmbeddingResponse> embedding(EmbeddingRequest request) {
        return new RequestExecutor(this.openAiApi.embeddings(request, this.apiVersion), r -> r);
    }

    @Override
    public SyncOrAsync<List<Float>> embedding(String input) {
        EmbeddingRequest request = EmbeddingRequest.builder().input(input).build();
        return new RequestExecutor(this.openAiApi.embeddings(request, this.apiVersion), EmbeddingResponse::embedding);
    }

    @Override
    public SyncOrAsync<ModerationResponse> moderation(ModerationRequest request) {
        return new RequestExecutor(this.openAiApi.moderations(request, this.apiVersion), r -> r);
    }

    @Override
    public SyncOrAsync<ModerationResult> moderation(String input) {
        ModerationRequest request = ModerationRequest.builder().input(input).build();
        return new RequestExecutor(this.openAiApi.moderations(request, this.apiVersion), r -> r.results().get(0));
    }

    @Override
    public SyncOrAsync<GenerateImagesResponse> imagesGeneration(GenerateImagesRequest request) {
        return new RequestExecutor(this.openAiApi.imagesGenerations(request, this.apiVersion), r -> r);
    }

    private String formatUrl(String endpoint) {
        return this.baseUrl + endpoint + this.apiVersionQueryParam();
    }

    private String apiVersionQueryParam() {
        if (this.apiVersion == null || this.apiVersion.trim().isEmpty()) {
            return "";
        }
        return "?api-version=" + this.apiVersion;
    }

    public static class Builder
    extends OpenAiClient.Builder<DefaultOpenAiClient, Builder> {
        @Override
        public DefaultOpenAiClient build() {
            return new DefaultOpenAiClient(this);
        }
    }
}

