/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.TerminateToolException;

public abstract class CmdLineTool {
    protected CmdLineTool() {
    }

    public String getName() {
        if (this.getClass().getName().endsWith("Tool")) {
            return this.getClass().getSimpleName().substring(0, this.getClass().getSimpleName().length() - 4);
        }
        return this.getClass().getSimpleName();
    }

    public boolean hasParams() {
        return true;
    }

    protected String getBasicHelp(Class<?> argProxyInterface) {
        return this.getBasicHelp(new Class[]{argProxyInterface});
    }

    protected String getBasicHelp(Class<?> ... argProxyInterfaces) {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(argProxyInterfaces);
    }

    public abstract String getHelp();

    protected <T> T validateAndParseParams(String[] args2, Class<T> argProxyInterface) {
        String errorMessage = ArgumentParser.validateArgumentsLoudly(args2, argProxyInterface);
        if (null != errorMessage) {
            throw new TerminateToolException(1, errorMessage + "\n" + this.getHelp());
        }
        return ArgumentParser.parse(args2, argProxyInterface);
    }

    public String getShortDescription() {
        return "";
    }
}

