/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.util.Map;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;

public abstract class TypedCmdLineTool<T>
extends CmdLineTool {
    protected final Class<T> type;

    protected TypedCmdLineTool(Class<T> sampleType) {
        this.type = sampleType;
    }

    protected ObjectStreamFactory<T> getStreamFactory(String format) {
        ObjectStreamFactory<T> factory2 = StreamFactoryRegistry.getFactory(this.type, format);
        if (null != factory2) {
            return factory2;
        }
        throw new TerminateToolException(1, "Format " + format + " is not found.\n" + this.getHelp());
    }

    protected <A> void validateAllArgs(String[] args2, Class<A> argProxyInterface, String format) {
        ObjectStreamFactory<T> factory2 = this.getStreamFactory(format);
        String errMessage = ArgumentParser.validateArgumentsLoudly(args2, argProxyInterface, factory2.getParameters());
        if (null != errMessage) {
            throw new TerminateToolException(1, errMessage + "\n" + this.getHelp(format));
        }
    }

    protected void validateFactoryArgs(ObjectStreamFactory<T> factory2, String[] args2) {
        String errMessage = ArgumentParser.validateArgumentsLoudly(args2, factory2.getParameters());
        if (null != errMessage) {
            throw new TerminateToolException(1, "Format parameters are invalid: " + errMessage + "\nUsage: " + ArgumentParser.createUsage(factory2.getParameters()));
        }
    }

    @Override
    protected String getBasicHelp(Class<?> ... argProxyInterfaces) {
        Map<String, ObjectStreamFactory<T>> factories = StreamFactoryRegistry.getFactories(this.type);
        String formatsHelp = " ";
        if (1 < factories.size()) {
            StringBuilder formats = new StringBuilder();
            for (String format : factories.keySet()) {
                if ("opennlp".equals(format)) continue;
                formats.append(".").append(format).append("|");
            }
            formatsHelp = "[" + formats.substring(0, formats.length() - 1) + "] ";
        }
        return "Usage: opennlp " + this.getName() + formatsHelp + ArgumentParser.createUsage(argProxyInterfaces);
    }

    @Override
    public String getHelp() {
        return this.getHelp("");
    }

    public abstract void run(String var1, String[] var2);

    public abstract String getHelp(String var1);
}

