/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.dictionary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.dictionary.DictionaryBuilderParams;
import opennlp.tools.dictionary.Dictionary;

public class DictionaryBuilderTool
extends BasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "builds a new dictionary";
    }

    @Override
    public String getHelp() {
        return this.getBasicHelp((Class<?>)Params.class);
    }

    @Override
    public void run(String[] args2) {
        Params params = this.validateAndParseParams(args2, Params.class);
        File dictInFile = params.getInputFile();
        File dictOutFile = params.getOutputFile();
        Charset encoding = params.getEncoding();
        CmdLineUtil.checkInputFile("dictionary input file", dictInFile);
        CmdLineUtil.checkOutputFile("dictionary output file", dictOutFile);
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(dictInFile), encoding);
             FileOutputStream out = new FileOutputStream(dictOutFile);){
            Dictionary dict = Dictionary.parseOneEntryPerLine(in);
            dict.serialize(out);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
    }

    static interface Params
    extends DictionaryBuilderParams {
    }
}

