/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.langdetect.LanguageDetectorSampleStream;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public class LanguageDetectorSampleStreamFactory
extends AbstractSampleStreamFactory<LanguageSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(LanguageSample.class, "opennlp", new LanguageDetectorSampleStreamFactory(Parameters.class));
    }

    protected <P> LanguageDetectorSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<LanguageSample> create(String[] args2) {
        Parameters params = ArgumentParser.parse(args2, Parameters.class);
        CmdLineUtil.checkInputFile("Data", params.getData());
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory(params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError(ex);
        }
        return new LanguageDetectorSampleStream(lineStream);
    }

    static interface Parameters
    extends BasicFormatParams {
    }
}

