/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.tools;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.langchain4j.tools.LangChain4jToolsConfiguration;
import org.apache.camel.component.langchain4j.tools.LangChain4jToolsEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;

@Component(value="langchain4j-tools")
public class LangChain4jToolsComponent
extends DefaultComponent {
    @Metadata
    LangChain4jToolsConfiguration configuration = new LangChain4jToolsConfiguration();

    public LangChain4jToolsComponent() {
        this(null);
    }

    public LangChain4jToolsComponent(CamelContext context) {
        super(context);
    }

    public LangChain4jToolsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(LangChain4jToolsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty(remaining)) {
            throw new IllegalArgumentException("Tool set and, optionally, the function, must be configured on the endpoint using syntax langchain4j-tools:toolId");
        }
        String toolId = StringHelper.before(remaining, "/", remaining);
        String tagList = parameters.get("tags").toString();
        if (ObjectHelper.isEmpty(tagList)) {
            throw new IllegalArgumentException("At least one tag must be specified");
        }
        LangChain4jToolsConfiguration langchain4jChatConfiguration = this.configuration.copy();
        Map<String, Object> toolParameters = PropertiesHelper.extractProperties(parameters, "parameter.");
        LangChain4jToolsEndpoint endpoint = new LangChain4jToolsEndpoint(uri, this, toolId, tagList, langchain4jChatConfiguration);
        endpoint.setParameters(toolParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue())));
        this.setProperties(endpoint, parameters);
        return endpoint;
    }
}

