/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.support.DefaultPollingEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ProcessorPollingConsumer;

public class ProcessorEndpoint
extends DefaultPollingEndpoint {
    private Processor processor;

    protected ProcessorEndpoint() {
    }

    public ProcessorEndpoint(String endpointUri, CamelContext context, Processor processor) {
        super(endpointUri, null);
        this.setCamelContext(context);
        this.processor = processor;
    }

    public ProcessorEndpoint(String endpointUri, Component component, Processor processor) {
        super(endpointUri, component);
        this.processor = processor;
    }

    protected ProcessorEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DefaultProducer(this){

            @Override
            public void process(Exchange exchange) throws Exception {
                ProcessorEndpoint.this.onExchange(exchange);
            }
        };
    }

    @Override
    public PollingConsumer createPollingConsumer() throws Exception {
        ProcessorPollingConsumer answer = new ProcessorPollingConsumer(this, this.getProcessor());
        this.configurePollingConsumer(answer);
        return answer;
    }

    public Processor getProcessor() throws Exception {
        if (this.processor == null) {
            this.processor = this.createProcessor();
        }
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    protected Processor createProcessor() throws Exception {
        return new Processor(){

            @Override
            public void process(Exchange exchange) throws Exception {
                ProcessorEndpoint.this.onExchange(exchange);
            }
        };
    }

    protected void onExchange(Exchange exchange) throws Exception {
        this.getProcessor().process(exchange);
    }
}

