/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.factory;

import java.util.Iterator;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.factory.Messagefactory;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.util.Strings;

public final class AddRequestFactory
implements Messagefactory {
    public static final AddRequestFactory INSTANCE = new AddRequestFactory();

    private AddRequestFactory() {
    }

    private void encodeValueReverse(Asn1Buffer buffer, Iterator<Value> iterator) {
        if (iterator.hasNext()) {
            Value value = iterator.next();
            this.encodeValueReverse(buffer, iterator);
            BerValue.encodeOctetString(buffer, value.getBytes());
        }
    }

    private void encodeAttributeReverse(Asn1Buffer buffer, Iterator<Attribute> iterator) {
        if (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            this.encodeAttributeReverse(buffer, iterator);
            int start = buffer.getPos();
            if (attribute.size() == 0) {
                BerValue.encodeOctetString(buffer, Strings.EMPTY_BYTES);
            } else {
                this.encodeValueReverse(buffer, attribute.iterator());
            }
            BerValue.encodeSet(buffer, start);
            BerValue.encodeOctetString(buffer, attribute.getUpId());
            BerValue.encodeSequence(buffer, start);
        }
    }

    @Override
    public void encodeReverse(LdapApiService codec, Asn1Buffer buffer, Message message) {
        int start = buffer.getPos();
        AddRequest addRequest = (AddRequest)message;
        Entry entry = addRequest.getEntry();
        if (entry.size() != 0) {
            this.encodeAttributeReverse(buffer, entry.iterator());
        }
        BerValue.encodeSequence(buffer, start);
        BerValue.encodeOctetString(buffer, entry.getDn().getName());
        BerValue.encodeSequence(buffer, (byte)104, start);
    }
}

