/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.syncrepl_impl;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateValue;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateValueImpl;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncStateValueContainer;
import org.apache.directory.api.ldap.model.message.Control;

public class SyncStateValueFactory
extends AbstractControlFactory<SyncStateValue> {
    public SyncStateValueFactory(LdapApiService codec) {
        super(codec, "1.3.6.1.4.1.4203.1.9.1.2");
    }

    @Override
    public SyncStateValue newControl() {
        return new SyncStateValueImpl();
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        int start = buffer.getPos();
        SyncStateValue syncStateValue = (SyncStateValue)control;
        if (syncStateValue.getCookie() != null) {
            BerValue.encodeOctetString(buffer, syncStateValue.getCookie());
        }
        BerValue.encodeOctetString(buffer, syncStateValue.getEntryUUID());
        BerValue.encodeEnumerated(buffer, syncStateValue.getSyncStateType().getValue());
        BerValue.encodeSequence(buffer, start);
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new SyncStateValueContainer(control), control, controlBytes);
    }
}

