/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.leveldb.serializer;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.leveldb.serializer.AbstractLevelDBSerializer;
import org.apache.camel.component.leveldb.serializer.jackson.ObjectMapperHelper;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultExchangeHolder;

public class JacksonLevelDBSerializer
extends AbstractLevelDBSerializer {
    private final ObjectMapper objectMapper;

    public JacksonLevelDBSerializer() {
        this(null);
    }

    public JacksonLevelDBSerializer(Module customMudule) {
        this.objectMapper = ObjectMapperHelper.create(customMudule);
    }

    @Override
    public byte[] serializeKey(String key) throws IOException {
        return this.objectMapper.writeValueAsBytes(key);
    }

    @Override
    public String deserializeKey(byte[] buffer) throws IOException {
        return this.objectMapper.readValue(buffer, String.class);
    }

    @Override
    public byte[] serializeExchange(CamelContext camelContext, Exchange exchange, boolean allowSerializedHeaders) throws IOException {
        Object inBody = exchange.getIn().getBody();
        Object outBody = null;
        if (exchange.getMessage() != null) {
            outBody = exchange.getMessage().getBody();
        }
        DefaultExchangeHolder pe = this.createExchangeHolder(exchange, allowSerializedHeaders);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                this.serializeByteArrayBody(inBody, dos);
                this.serializeByteArrayBody(outBody, dos);
                this.objectMapper.writeValue(baos, (Object)pe);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    public Exchange deserializeExchange(CamelContext camelContext, byte[] buffer) throws IOException {
        DefaultExchangeHolder pe;
        Object outBody;
        Object inBody;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
             DataInputStream dis = new DataInputStream(bis);){
            inBody = this.deserializeByteArrayBody(dis);
            outBody = this.deserializeByteArrayBody(dis);
            pe = this.objectMapper.readValue((InputStream)bis, DefaultExchangeHolder.class);
        }
        DefaultExchange answer = new DefaultExchange(camelContext);
        DefaultExchangeHolder.unmarshal(answer, pe);
        if (inBody != null) {
            answer.getIn().setBody(inBody);
        }
        if (outBody != null) {
            answer.getMessage().setBody(outBody);
        }
        return answer;
    }

    private void serializeByteArrayBody(Object body, DataOutputStream dos) throws IOException {
        if (body instanceof byte[]) {
            int length = ((byte[])body).length;
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(length);
            dos.write(bb.array());
            dos.write((byte[])body);
        } else {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(0);
            dos.write(bb.array());
        }
    }

    private Object deserializeByteArrayBody(DataInputStream dis) throws IOException {
        byte[] b = new byte[4];
        dis.read(b);
        int length = ByteBuffer.wrap(b).getInt();
        byte[] payload = null;
        if (length > 0) {
            payload = new byte[length];
            dis.read(payload);
        }
        return payload;
    }
}

