/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Objects;
import org.iq80.leveldb.util.Closeables;

public class DbLock {
    private final File lockFile;
    private final FileChannel channel;
    private final FileLock lock;

    public DbLock(File lockFile) throws IOException {
        Objects.requireNonNull(lockFile, "lockFile is null");
        this.lockFile = lockFile;
        this.channel = new RandomAccessFile(lockFile, "rw").getChannel();
        try {
            this.lock = this.channel.tryLock();
        }
        catch (IOException e) {
            Closeables.closeQuietly(this.channel);
            throw e;
        }
        if (this.lock == null) {
            throw new IOException(String.format("Unable to acquire lock on '%s'", lockFile.getAbsolutePath()));
        }
    }

    public boolean isValid() {
        return this.lock.isValid();
    }

    public void release() {
        try {
            this.lock.release();
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
        finally {
            Closeables.closeQuietly(this.channel);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DbLock");
        sb.append("{lockFile=").append(this.lockFile);
        sb.append(", lock=").append(this.lock);
        sb.append('}');
        return sb.toString();
    }
}

