/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.leveldb.serializer;

import java.io.IOException;
import java.io.Serializable;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.component.leveldb.LevelDBSerializer;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultExchangeHolder;

public abstract class AbstractLevelDBSerializer
implements LevelDBSerializer {
    protected byte[] serializeExchange(Exchange exchange, boolean allowSerializedHeaders, Serializer serializer) throws IOException {
        DefaultExchangeHolder pe = this.createExchangeHolder(exchange, allowSerializedHeaders);
        return serializer.serialize(pe);
    }

    protected Exchange deserializeExchange(CamelContext camelContext, byte[] buffer, Deserializer deserializer) throws IOException {
        DefaultExchangeHolder pe = deserializer.deserialize(buffer);
        DefaultExchange answer = new DefaultExchange(camelContext);
        DefaultExchangeHolder.unmarshal(answer, pe);
        return answer;
    }

    DefaultExchangeHolder createExchangeHolder(Exchange exchange, boolean allowSerializedHeaders) {
        DefaultExchangeHolder pe = DefaultExchangeHolder.marshal(exchange, false, allowSerializedHeaders);
        DefaultExchangeHolder.addProperty(pe, "CamelAggregatedSize", exchange.getProperty(ExchangePropertyKey.AGGREGATED_SIZE, Integer.class));
        DefaultExchangeHolder.addProperty(pe, "CamelAggregatedTimeout", exchange.getProperty(ExchangePropertyKey.AGGREGATED_TIMEOUT, Long.class));
        DefaultExchangeHolder.addProperty(pe, "CamelAggregatedCompletedBy", (Serializable)((Object)exchange.getProperty(ExchangePropertyKey.AGGREGATED_COMPLETED_BY, String.class)));
        DefaultExchangeHolder.addProperty(pe, "CamelAggregatedCorrelationKey", (Serializable)((Object)exchange.getProperty(ExchangePropertyKey.AGGREGATED_CORRELATION_KEY, String.class)));
        DefaultExchangeHolder.addProperty(pe, "CamelAggregatedCollectionGuard", (Serializable)((Object)exchange.getProperty("CamelAggregatedCollectionGuard", String.class)));
        if (exchange.getFromEndpoint() != null) {
            DefaultExchangeHolder.addProperty(pe, "CamelAggregatedFromEndpoint", (Serializable)((Object)exchange.getFromEndpoint().getEndpointUri()));
        }
        return pe;
    }

    @FunctionalInterface
    protected static interface Serializer {
        public byte[] serialize(DefaultExchangeHolder var1) throws IOException;
    }

    @FunctionalInterface
    protected static interface Deserializer {
        public DefaultExchangeHolder deserialize(byte[] var1) throws IOException;
    }
}

