/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

public final class Filename {
    private Filename() {
    }

    public static String logFileName(long number) {
        return Filename.makeFileName(number, "log");
    }

    public static String tableFileName(long number) {
        return Filename.makeFileName(number, "sst");
    }

    public static String descriptorFileName(long number) {
        Preconditions.checkArgument(number >= 0L, "number is negative");
        return String.format("MANIFEST-%06d", number);
    }

    public static String currentFileName() {
        return "CURRENT";
    }

    public static String lockFileName() {
        return "LOCK";
    }

    public static String tempFileName(long number) {
        return Filename.makeFileName(number, "dbtmp");
    }

    public static String infoLogFileName() {
        return "LOG";
    }

    public static String oldInfoLogFileName() {
        return "LOG.old";
    }

    public static FileInfo parseFileName(File file) {
        String fileName = file.getName();
        if ("CURRENT".equals(fileName)) {
            return new FileInfo(FileType.CURRENT);
        }
        if ("LOCK".equals(fileName)) {
            return new FileInfo(FileType.DB_LOCK);
        }
        if ("LOG".equals(fileName)) {
            return new FileInfo(FileType.INFO_LOG);
        }
        if ("LOG.old".equals(fileName)) {
            return new FileInfo(FileType.INFO_LOG);
        }
        if (fileName.startsWith("MANIFEST-")) {
            long fileNumber = Long.parseLong(Filename.removePrefix(fileName, "MANIFEST-"));
            return new FileInfo(FileType.DESCRIPTOR, fileNumber);
        }
        if (fileName.endsWith(".log")) {
            long fileNumber = Long.parseLong(Filename.removeSuffix(fileName, ".log"));
            return new FileInfo(FileType.LOG, fileNumber);
        }
        if (fileName.endsWith(".sst")) {
            long fileNumber = Long.parseLong(Filename.removeSuffix(fileName, ".sst"));
            return new FileInfo(FileType.TABLE, fileNumber);
        }
        if (fileName.endsWith(".dbtmp")) {
            long fileNumber = Long.parseLong(Filename.removeSuffix(fileName, ".dbtmp"));
            return new FileInfo(FileType.TEMP, fileNumber);
        }
        return null;
    }

    public static boolean setCurrentFile(File databaseDir, long descriptorNumber) throws IOException {
        String manifest = Filename.descriptorFileName(descriptorNumber);
        String temp = Filename.tempFileName(descriptorNumber);
        File tempFile = new File(databaseDir, temp);
        Filename.writeStringToFileSync(manifest + "\n", tempFile);
        File to = new File(databaseDir, Filename.currentFileName());
        boolean ok = tempFile.renameTo(to);
        if (!ok) {
            tempFile.delete();
            Filename.writeStringToFileSync(manifest + "\n", to);
        }
        return ok;
    }

    private static void writeStringToFileSync(String str, File file) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(file);){
            stream.write(str.getBytes(StandardCharsets.UTF_8));
            stream.flush();
            stream.getFD().sync();
        }
    }

    public static List<File> listFiles(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(files);
    }

    private static String makeFileName(long number, String suffix) {
        Preconditions.checkArgument(number >= 0L, "number is negative");
        Objects.requireNonNull(suffix, "suffix is null");
        return String.format("%06d.%s", number, suffix);
    }

    private static String removePrefix(String value, String prefix) {
        return value.substring(prefix.length());
    }

    private static String removeSuffix(String value, String suffix) {
        return value.substring(0, value.length() - suffix.length());
    }

    public static class FileInfo {
        private final FileType fileType;
        private final long fileNumber;

        public FileInfo(FileType fileType) {
            this(fileType, 0L);
        }

        public FileInfo(FileType fileType, long fileNumber) {
            Objects.requireNonNull(fileType, "fileType is null");
            this.fileType = fileType;
            this.fileNumber = fileNumber;
        }

        public FileType getFileType() {
            return this.fileType;
        }

        public long getFileNumber() {
            return this.fileNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileInfo fileInfo = (FileInfo)o;
            if (this.fileNumber != fileInfo.fileNumber) {
                return false;
            }
            return this.fileType == fileInfo.fileType;
        }

        public int hashCode() {
            int result = this.fileType.hashCode();
            result = 31 * result + (int)(this.fileNumber ^ this.fileNumber >>> 32);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("FileInfo");
            sb.append("{fileType=").append((Object)this.fileType);
            sb.append(", fileNumber=").append(this.fileNumber);
            sb.append('}');
            return sb.toString();
        }
    }

    public static enum FileType {
        LOG,
        DB_LOCK,
        TABLE,
        DESCRIPTOR,
        CURRENT,
        TEMP,
        INFO_LOG;

    }
}

