/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.LookupKey;
import org.iq80.leveldb.impl.LookupResult;
import org.iq80.leveldb.impl.ReadStats;
import org.iq80.leveldb.impl.SeekingIterable;
import org.iq80.leveldb.impl.TableCache;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.table.UserComparator;
import org.iq80.leveldb.util.InternalTableIterator;
import org.iq80.leveldb.util.LevelIterator;
import org.iq80.leveldb.util.Slice;

public class Level
implements SeekingIterable<InternalKey, Slice> {
    private final int levelNumber;
    private final TableCache tableCache;
    private final InternalKeyComparator internalKeyComparator;
    private final List<FileMetaData> files;

    public Level(int levelNumber, List<FileMetaData> files, TableCache tableCache, InternalKeyComparator internalKeyComparator) {
        Preconditions.checkArgument(levelNumber >= 0, "levelNumber is negative");
        Objects.requireNonNull(files, "files is null");
        Objects.requireNonNull(tableCache, "tableCache is null");
        Objects.requireNonNull(internalKeyComparator, "internalKeyComparator is null");
        this.files = new ArrayList<FileMetaData>(files);
        this.tableCache = tableCache;
        this.internalKeyComparator = internalKeyComparator;
        Preconditions.checkArgument(levelNumber >= 0, "levelNumber is negative");
        this.levelNumber = levelNumber;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public List<FileMetaData> getFiles() {
        return this.files;
    }

    @Override
    public LevelIterator iterator() {
        return Level.createLevelConcatIterator(this.tableCache, this.files, this.internalKeyComparator);
    }

    public static LevelIterator createLevelConcatIterator(TableCache tableCache, List<FileMetaData> files, InternalKeyComparator internalKeyComparator) {
        return new LevelIterator(tableCache, files, internalKeyComparator);
    }

    public LookupResult get(LookupKey key, ReadStats readStats) {
        if (this.files.isEmpty()) {
            return null;
        }
        ArrayList<FileMetaData> fileMetaDataList = new ArrayList<FileMetaData>(this.files.size());
        if (this.levelNumber == 0) {
            for (FileMetaData fileMetaData : this.files) {
                if (this.internalKeyComparator.getUserComparator().compare(key.getUserKey(), fileMetaData.getSmallest().getUserKey()) < 0 || this.internalKeyComparator.getUserComparator().compare(key.getUserKey(), fileMetaData.getLargest().getUserKey()) > 0) continue;
                fileMetaDataList.add(fileMetaData);
            }
        } else {
            FileMetaData fileMetaData;
            int index = Level.ceilingEntryIndex(Lists.transform(this.files, FileMetaData::getLargest), key.getInternalKey(), this.internalKeyComparator);
            if (index >= this.files.size()) {
                return null;
            }
            fileMetaData = this.files.get(index);
            if (this.internalKeyComparator.getUserComparator().compare(key.getUserKey(), fileMetaData.getSmallest().getUserKey()) < 0) {
                return null;
            }
            fileMetaDataList.add(fileMetaData);
        }
        FileMetaData lastFileRead = null;
        int lastFileReadLevel = -1;
        readStats.clear();
        for (FileMetaData fileMetaData : fileMetaDataList) {
            if (lastFileRead != null && readStats.getSeekFile() == null) {
                readStats.setSeekFile(lastFileRead);
                readStats.setSeekFileLevel(lastFileReadLevel);
            }
            lastFileRead = fileMetaData;
            lastFileReadLevel = this.levelNumber;
            InternalTableIterator iterator = this.tableCache.newIterator(fileMetaData);
            iterator.seek(key.getInternalKey());
            if (!iterator.hasNext()) continue;
            Object entry = iterator.next();
            InternalKey internalKey = (InternalKey)entry.getKey();
            Preconditions.checkState(internalKey != null, "Corrupt key for %s", (Object)key.getUserKey().toString(StandardCharsets.UTF_8));
            if (!key.getUserKey().equals(internalKey.getUserKey())) continue;
            if (internalKey.getValueType() == ValueType.DELETION) {
                return LookupResult.deleted(key);
            }
            if (internalKey.getValueType() != ValueType.VALUE) continue;
            return LookupResult.ok(key, (Slice)entry.getValue());
        }
        return null;
    }

    private static <T> int ceilingEntryIndex(List<T> list, T key, Comparator<T> comparator) {
        int insertionPoint = Collections.binarySearch(list, key, comparator);
        if (insertionPoint < 0) {
            insertionPoint = -(insertionPoint + 1);
        }
        return insertionPoint;
    }

    public boolean someFileOverlapsRange(Slice smallestUserKey, Slice largestUserKey) {
        InternalKey smallestInternalKey = new InternalKey(smallestUserKey, 0xFFFFFFFFFFFFFFL, ValueType.VALUE);
        int index = this.findFile(smallestInternalKey);
        UserComparator userComparator = this.internalKeyComparator.getUserComparator();
        return index < this.files.size() && userComparator.compare(largestUserKey, this.files.get(index).getSmallest().getUserKey()) >= 0;
    }

    private int findFile(InternalKey targetKey) {
        if (this.files.isEmpty()) {
            return this.files.size();
        }
        int left = 0;
        int right = this.files.size() - 1;
        while (left < right) {
            int mid = (left + right) / 2;
            if (this.internalKeyComparator.compare(this.files.get(mid).getLargest(), targetKey) < 0) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        return right;
    }

    public void addFile(FileMetaData fileMetaData) {
        this.files.add(fileMetaData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Level");
        sb.append("{levelNumber=").append(this.levelNumber);
        sb.append(", files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

