/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.lucene.LuceneComponent;
import org.apache.camel.component.lucene.LuceneConfiguration;
import org.apache.camel.component.lucene.LuceneConstants;
import org.apache.camel.component.lucene.LuceneIndexProducer;
import org.apache.camel.component.lucene.LuceneIndexer;
import org.apache.camel.component.lucene.LuceneOperation;
import org.apache.camel.component.lucene.LuceneQueryProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.2.0", scheme="lucene", title="Lucene", syntax="lucene:host:operation", producerOnly=true, category={Category.DATABASE, Category.SEARCH}, headersClass=LuceneConstants.class)
public class LuceneEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    private LuceneIndexer indexer;
    private boolean insertFlag;
    @UriParam
    LuceneConfiguration config;

    public LuceneEndpoint() {
    }

    public LuceneEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public LuceneEndpoint(String endpointUri, LuceneComponent component, LuceneConfiguration config) throws Exception {
        this(endpointUri, component);
        this.config = config;
        if (config.getOperation() == LuceneOperation.insert) {
            this.indexer = new LuceneIndexer(config.getSrcDir(), config.getIndexDir(), config.getAnalyzer());
            this.insertFlag = true;
        }
    }

    @Override
    public String getServiceUrl() {
        if (this.config != null) {
            return this.config.getHost();
        }
        return null;
    }

    @Override
    public String getServiceProtocol() {
        return "lucene";
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for Lucene endpoint");
    }

    @Override
    public Producer createProducer() throws Exception {
        if (!this.insertFlag) {
            return new LuceneQueryProducer(this, this.config);
        }
        return new LuceneIndexProducer(this, this.config, this.indexer);
    }

    public LuceneConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(LuceneConfiguration config) {
        this.config = config;
    }
}

