/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lumberjack.io;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import org.apache.camel.component.lumberjack.io.LumberjackAck;
import org.apache.camel.component.lumberjack.io.LumberjackMessage;
import org.apache.camel.component.lumberjack.io.LumberjackMessageProcessor;
import org.apache.camel.component.lumberjack.io.LumberjackWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LumberjackMessageHandler
extends SimpleChannelInboundHandler<LumberjackWindow> {
    private static final Logger LOG = LoggerFactory.getLogger(LumberjackMessageHandler.class);
    private final LumberjackMessageProcessor messageProcessor;
    private volatile boolean process = true;

    LumberjackMessageHandler(LumberjackMessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            LOG.debug("IO exception (client connection closed ?)", cause);
        } else {
            LOG.warn("Caught an exception while reading, closing channel.", cause);
        }
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, LumberjackWindow window) throws Exception {
        try {
            for (LumberjackMessage msg : window) {
                if (!this.process) continue;
                this.messageProcessor.onMessageReceived(msg.getPayload(), success -> {
                    if (success) {
                        this.notifyMessageProcessed(ctx, msg.getSequenceNumber(), window);
                    } else {
                        ctx.close();
                        this.process = false;
                    }
                });
            }
        }
        finally {
            ctx.flush();
        }
    }

    private void notifyMessageProcessed(ChannelHandlerContext ctx, int sequenceNumber, LumberjackWindow window) {
        if (sequenceNumber == window.getSize()) {
            ctx.writeAndFlush(new LumberjackAck(window.getVersion(), sequenceNumber));
        }
    }
}

