/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import jakarta.mail.Session;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.mail.AttachmentsContentTransferEncodingResolver;
import org.apache.camel.component.mail.ContentTypeResolver;
import org.apache.camel.component.mail.JavaMailSender;
import org.apache.camel.component.mail.MailAuthenticator;
import org.apache.camel.component.mail.MailComponent;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;

public class MailComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private MailConfiguration getOrCreateConfiguration(MailComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new MailConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        MailComponent target = (MailComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "additionaljavamailproperties": 
            case "additionalJavaMailProperties": {
                this.getOrCreateConfiguration(target).setAdditionalJavaMailProperties(MailComponentConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "alternativebodyheader": 
            case "alternativeBodyHeader": {
                this.getOrCreateConfiguration(target).setAlternativeBodyHeader(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "attachmentscontenttransferencodingresolver": 
            case "attachmentsContentTransferEncodingResolver": {
                this.getOrCreateConfiguration(target).setAttachmentsContentTransferEncodingResolver(MailComponentConfigurer.property(camelContext, AttachmentsContentTransferEncodingResolver.class, value));
                return true;
            }
            case "authenticator": {
                this.getOrCreateConfiguration(target).setAuthenticator(MailComponentConfigurer.property(camelContext, MailAuthenticator.class, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bcc": {
                this.getOrCreateConfiguration(target).setBcc(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "cc": {
                this.getOrCreateConfiguration(target).setCc(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "closefolder": 
            case "closeFolder": {
                this.getOrCreateConfiguration(target).setCloseFolder(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(MailComponentConfigurer.property(camelContext, MailConfiguration.class, value));
                return true;
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                this.getOrCreateConfiguration(target).setConnectionTimeout(MailComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "contenttype": 
            case "contentType": {
                this.getOrCreateConfiguration(target).setContentType(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "contenttyperesolver": 
            case "contentTypeResolver": {
                target.setContentTypeResolver(MailComponentConfigurer.property(camelContext, ContentTypeResolver.class, value));
                return true;
            }
            case "copyto": 
            case "copyTo": {
                this.getOrCreateConfiguration(target).setCopyTo(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "debugmode": 
            case "debugMode": {
                this.getOrCreateConfiguration(target).setDebugMode(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "decodefilename": 
            case "decodeFilename": {
                this.getOrCreateConfiguration(target).setDecodeFilename(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "delete": {
                this.getOrCreateConfiguration(target).setDelete(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "disconnect": {
                this.getOrCreateConfiguration(target).setDisconnect(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "failonduplicatefileattachment": 
            case "failOnDuplicateFileAttachment": {
                this.getOrCreateConfiguration(target).setFailOnDuplicateFileAttachment(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "fetchsize": 
            case "fetchSize": {
                this.getOrCreateConfiguration(target).setFetchSize(MailComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "foldername": 
            case "folderName": {
                this.getOrCreateConfiguration(target).setFolderName(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "from": {
                this.getOrCreateConfiguration(target).setFrom(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "generatemissingattachmentnames": 
            case "generateMissingAttachmentNames": {
                this.getOrCreateConfiguration(target).setGenerateMissingAttachmentNames(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "handleduplicateattachmentnames": 
            case "handleDuplicateAttachmentNames": {
                this.getOrCreateConfiguration(target).setHandleDuplicateAttachmentNames(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "handlefailedmessage": 
            case "handleFailedMessage": {
                this.getOrCreateConfiguration(target).setHandleFailedMessage(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                target.setHeaderFilterStrategy(MailComponentConfigurer.property(camelContext, HeaderFilterStrategy.class, value));
                return true;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                target.setHealthCheckConsumerEnabled(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                target.setHealthCheckProducerEnabled(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "ignoreunsupportedcharset": 
            case "ignoreUnsupportedCharset": {
                this.getOrCreateConfiguration(target).setIgnoreUnsupportedCharset(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "ignoreurischeme": 
            case "ignoreUriScheme": {
                this.getOrCreateConfiguration(target).setIgnoreUriScheme(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "javamailproperties": 
            case "javaMailProperties": {
                this.getOrCreateConfiguration(target).setJavaMailProperties(MailComponentConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "javamailsender": 
            case "javaMailSender": {
                this.getOrCreateConfiguration(target).setJavaMailSender(MailComponentConfigurer.property(camelContext, JavaMailSender.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "mapmailmessage": 
            case "mapMailMessage": {
                this.getOrCreateConfiguration(target).setMapMailMessage(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "mimedecodeheaders": 
            case "mimeDecodeHeaders": {
                this.getOrCreateConfiguration(target).setMimeDecodeHeaders(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "moveto": 
            case "moveTo": {
                this.getOrCreateConfiguration(target).setMoveTo(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "peek": {
                this.getOrCreateConfiguration(target).setPeek(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "replyto": 
            case "replyTo": {
                this.getOrCreateConfiguration(target).setReplyTo(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "session": {
                this.getOrCreateConfiguration(target).setSession(MailComponentConfigurer.property(camelContext, Session.class, value));
                return true;
            }
            case "skipfailedmessage": 
            case "skipFailedMessage": {
                this.getOrCreateConfiguration(target).setSkipFailedMessage(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                this.getOrCreateConfiguration(target).setSslContextParameters(MailComponentConfigurer.property(camelContext, SSLContextParameters.class, value));
                return true;
            }
            case "subject": {
                this.getOrCreateConfiguration(target).setSubject(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "to": {
                this.getOrCreateConfiguration(target).setTo(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "unseen": {
                this.getOrCreateConfiguration(target).setUnseen(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                target.setUseGlobalSslContextParameters(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "useinlineattachments": 
            case "useInlineAttachments": {
                this.getOrCreateConfiguration(target).setUseInlineAttachments(MailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "username": {
                this.getOrCreateConfiguration(target).setUsername(MailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "additionaljavamailproperties": 
            case "additionalJavaMailProperties": {
                return Properties.class;
            }
            case "alternativebodyheader": 
            case "alternativeBodyHeader": {
                return String.class;
            }
            case "attachmentscontenttransferencodingresolver": 
            case "attachmentsContentTransferEncodingResolver": {
                return AttachmentsContentTransferEncodingResolver.class;
            }
            case "authenticator": {
                return MailAuthenticator.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bcc": {
                return String.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "cc": {
                return String.class;
            }
            case "closefolder": 
            case "closeFolder": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return MailConfiguration.class;
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                return Integer.TYPE;
            }
            case "contenttype": 
            case "contentType": {
                return String.class;
            }
            case "contenttyperesolver": 
            case "contentTypeResolver": {
                return ContentTypeResolver.class;
            }
            case "copyto": 
            case "copyTo": {
                return String.class;
            }
            case "debugmode": 
            case "debugMode": {
                return Boolean.TYPE;
            }
            case "decodefilename": 
            case "decodeFilename": {
                return Boolean.TYPE;
            }
            case "delete": {
                return Boolean.TYPE;
            }
            case "disconnect": {
                return Boolean.TYPE;
            }
            case "failonduplicatefileattachment": 
            case "failOnDuplicateFileAttachment": {
                return Boolean.TYPE;
            }
            case "fetchsize": 
            case "fetchSize": {
                return Integer.TYPE;
            }
            case "foldername": 
            case "folderName": {
                return String.class;
            }
            case "from": {
                return String.class;
            }
            case "generatemissingattachmentnames": 
            case "generateMissingAttachmentNames": {
                return String.class;
            }
            case "handleduplicateattachmentnames": 
            case "handleDuplicateAttachmentNames": {
                return String.class;
            }
            case "handlefailedmessage": 
            case "handleFailedMessage": {
                return Boolean.TYPE;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return HeaderFilterStrategy.class;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return Boolean.TYPE;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return Boolean.TYPE;
            }
            case "ignoreunsupportedcharset": 
            case "ignoreUnsupportedCharset": {
                return Boolean.TYPE;
            }
            case "ignoreurischeme": 
            case "ignoreUriScheme": {
                return Boolean.TYPE;
            }
            case "javamailproperties": 
            case "javaMailProperties": {
                return Properties.class;
            }
            case "javamailsender": 
            case "javaMailSender": {
                return JavaMailSender.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "mapmailmessage": 
            case "mapMailMessage": {
                return Boolean.TYPE;
            }
            case "mimedecodeheaders": 
            case "mimeDecodeHeaders": {
                return Boolean.TYPE;
            }
            case "moveto": 
            case "moveTo": {
                return String.class;
            }
            case "password": {
                return String.class;
            }
            case "peek": {
                return Boolean.TYPE;
            }
            case "replyto": 
            case "replyTo": {
                return String.class;
            }
            case "session": {
                return Session.class;
            }
            case "skipfailedmessage": 
            case "skipFailedMessage": {
                return Boolean.TYPE;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return SSLContextParameters.class;
            }
            case "subject": {
                return String.class;
            }
            case "to": {
                return String.class;
            }
            case "unseen": {
                return Boolean.TYPE;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return Boolean.TYPE;
            }
            case "useinlineattachments": 
            case "useInlineAttachments": {
                return Boolean.TYPE;
            }
            case "username": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        MailComponent target = (MailComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "additionaljavamailproperties": 
            case "additionalJavaMailProperties": {
                return this.getOrCreateConfiguration(target).getAdditionalJavaMailProperties();
            }
            case "alternativebodyheader": 
            case "alternativeBodyHeader": {
                return this.getOrCreateConfiguration(target).getAlternativeBodyHeader();
            }
            case "attachmentscontenttransferencodingresolver": 
            case "attachmentsContentTransferEncodingResolver": {
                return this.getOrCreateConfiguration(target).getAttachmentsContentTransferEncodingResolver();
            }
            case "authenticator": {
                return this.getOrCreateConfiguration(target).getAuthenticator();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bcc": {
                return this.getOrCreateConfiguration(target).getBcc();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "cc": {
                return this.getOrCreateConfiguration(target).getCc();
            }
            case "closefolder": 
            case "closeFolder": {
                return this.getOrCreateConfiguration(target).isCloseFolder();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                return this.getOrCreateConfiguration(target).getConnectionTimeout();
            }
            case "contenttype": 
            case "contentType": {
                return this.getOrCreateConfiguration(target).getContentType();
            }
            case "contenttyperesolver": 
            case "contentTypeResolver": {
                return target.getContentTypeResolver();
            }
            case "copyto": 
            case "copyTo": {
                return this.getOrCreateConfiguration(target).getCopyTo();
            }
            case "debugmode": 
            case "debugMode": {
                return this.getOrCreateConfiguration(target).isDebugMode();
            }
            case "decodefilename": 
            case "decodeFilename": {
                return this.getOrCreateConfiguration(target).isDecodeFilename();
            }
            case "delete": {
                return this.getOrCreateConfiguration(target).isDelete();
            }
            case "disconnect": {
                return this.getOrCreateConfiguration(target).isDisconnect();
            }
            case "failonduplicatefileattachment": 
            case "failOnDuplicateFileAttachment": {
                return this.getOrCreateConfiguration(target).isFailOnDuplicateFileAttachment();
            }
            case "fetchsize": 
            case "fetchSize": {
                return this.getOrCreateConfiguration(target).getFetchSize();
            }
            case "foldername": 
            case "folderName": {
                return this.getOrCreateConfiguration(target).getFolderName();
            }
            case "from": {
                return this.getOrCreateConfiguration(target).getFrom();
            }
            case "generatemissingattachmentnames": 
            case "generateMissingAttachmentNames": {
                return this.getOrCreateConfiguration(target).getGenerateMissingAttachmentNames();
            }
            case "handleduplicateattachmentnames": 
            case "handleDuplicateAttachmentNames": {
                return this.getOrCreateConfiguration(target).getHandleDuplicateAttachmentNames();
            }
            case "handlefailedmessage": 
            case "handleFailedMessage": {
                return this.getOrCreateConfiguration(target).isHandleFailedMessage();
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return target.getHeaderFilterStrategy();
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return target.isHealthCheckConsumerEnabled();
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return target.isHealthCheckProducerEnabled();
            }
            case "ignoreunsupportedcharset": 
            case "ignoreUnsupportedCharset": {
                return this.getOrCreateConfiguration(target).isIgnoreUnsupportedCharset();
            }
            case "ignoreurischeme": 
            case "ignoreUriScheme": {
                return this.getOrCreateConfiguration(target).isIgnoreUriScheme();
            }
            case "javamailproperties": 
            case "javaMailProperties": {
                return this.getOrCreateConfiguration(target).getJavaMailProperties();
            }
            case "javamailsender": 
            case "javaMailSender": {
                return this.getOrCreateConfiguration(target).getJavaMailSender();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "mapmailmessage": 
            case "mapMailMessage": {
                return this.getOrCreateConfiguration(target).isMapMailMessage();
            }
            case "mimedecodeheaders": 
            case "mimeDecodeHeaders": {
                return this.getOrCreateConfiguration(target).isMimeDecodeHeaders();
            }
            case "moveto": 
            case "moveTo": {
                return this.getOrCreateConfiguration(target).getMoveTo();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "peek": {
                return this.getOrCreateConfiguration(target).isPeek();
            }
            case "replyto": 
            case "replyTo": {
                return this.getOrCreateConfiguration(target).getReplyTo();
            }
            case "session": {
                return this.getOrCreateConfiguration(target).getSession();
            }
            case "skipfailedmessage": 
            case "skipFailedMessage": {
                return this.getOrCreateConfiguration(target).isSkipFailedMessage();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return this.getOrCreateConfiguration(target).getSslContextParameters();
            }
            case "subject": {
                return this.getOrCreateConfiguration(target).getSubject();
            }
            case "to": {
                return this.getOrCreateConfiguration(target).getTo();
            }
            case "unseen": {
                return this.getOrCreateConfiguration(target).isUnseen();
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return target.isUseGlobalSslContextParameters();
            }
            case "useinlineattachments": 
            case "useInlineAttachments": {
                return this.getOrCreateConfiguration(target).isUseInlineAttachments();
            }
            case "username": {
                return this.getOrCreateConfiguration(target).getUsername();
            }
        }
        return null;
    }
}

