/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.search.SearchTerm;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.mail.NowSearchTerm;
import org.apache.camel.component.mail.SearchTermBuilder;
import org.apache.camel.component.mail.SimpleSearchTerm;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.TimeUtils;
import org.eclipse.angus.mail.imap.SortTerm;

@Converter(generateLoader=true)
public final class MailConverters {
    private static final String NOW_DATE_FORMAT = "yyyy-MM-dd HH:mm:SS";
    private static final Pattern NOW_PATTERN = Pattern.compile("now\\s?(\\+|\\-)\\s?(.*)");

    private MailConverters() {
    }

    @Converter
    public static String toString(Message message) throws MessagingException, IOException {
        Object content = message.getContent();
        while (content instanceof MimeMultipart) {
            MimeMultipart multipart = (MimeMultipart)content;
            if (multipart.getCount() <= 0) continue;
            BodyPart part = multipart.getBodyPart(0);
            content = part.getContent();
        }
        if (content != null) {
            return content.toString();
        }
        return null;
    }

    @Converter
    public static String toString(Multipart multipart) throws MessagingException, IOException {
        block4: {
            try {
                int size = multipart.getCount();
                for (int i = 0; i < size; ++i) {
                    BodyPart part = multipart.getBodyPart(i);
                    Object content = part.getContent();
                    while (content instanceof MimeMultipart && multipart.getCount() >= 1) {
                        part = ((MimeMultipart)content).getBodyPart(0);
                        content = part.getContent();
                    }
                    String prefix = "text";
                    if (!part.getContentType().regionMatches(true, 0, prefix, 0, prefix.length())) continue;
                    return part.getContent().toString();
                }
            }
            catch (MessagingException e) {
                Throwable cause = e.getCause();
                if (cause != null && "Folder is not Open".equals(cause.getMessage())) break block4;
                throw e;
            }
        }
        return null;
    }

    @Converter
    public static InputStream toInputStream(Message message) throws IOException, MessagingException {
        return message.getInputStream();
    }

    @Converter
    public static InputStream toInputStream(Multipart multipart, Exchange exchange) throws IOException, MessagingException {
        String s = MailConverters.toString(multipart);
        if (s == null) {
            return null;
        }
        return new ByteArrayInputStream(s.getBytes(ExchangeHelper.getCharsetName(exchange)));
    }

    @Converter(fallback=true)
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) throws MessagingException, IOException {
        String s;
        TypeConverter tc;
        if (Multipart.class.isAssignableFrom(value.getClass()) && (tc = registry.lookup(type, String.class)) != null && (s = MailConverters.toString((Multipart)value)) != null) {
            return tc.convertTo(type, s);
        }
        return null;
    }

    public static SearchTerm toSearchTerm(SimpleSearchTerm simple) throws ParseException {
        Date date;
        String s;
        SearchTermBuilder builder = new SearchTermBuilder();
        if (simple.isUnseen()) {
            builder = builder.unseen();
        }
        if (simple.getSubjectOrBody() != null) {
            String text = simple.getSubjectOrBody();
            SearchTermBuilder builderTemp = new SearchTermBuilder();
            builderTemp = builderTemp.subject(text).body(SearchTermBuilder.Op.or, text);
            builder = builder.and(builderTemp.build());
        }
        if (simple.getSubject() != null) {
            builder = builder.subject(simple.getSubject());
        }
        if (simple.getBody() != null) {
            builder = builder.body(simple.getBody());
        }
        if (simple.getFrom() != null) {
            builder = builder.from(simple.getFrom());
        }
        if (simple.getTo() != null) {
            builder = builder.recipient(Message.RecipientType.TO, simple.getTo());
        }
        if (simple.getFromSentDate() != null) {
            s = simple.getFromSentDate();
            if (s.startsWith("now")) {
                long offset = MailConverters.extractOffset(s);
                builder = builder.and(new NowSearchTerm(SearchTermBuilder.Comparison.GE.asNum(), true, offset));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(NOW_DATE_FORMAT);
                date = sdf.parse(s);
                builder = builder.sent(SearchTermBuilder.Comparison.GE, date);
            }
        }
        if (simple.getToSentDate() != null) {
            s = simple.getToSentDate();
            if (s.startsWith("now")) {
                long offset = MailConverters.extractOffset(s);
                builder = builder.and(new NowSearchTerm(SearchTermBuilder.Comparison.LE.asNum(), true, offset));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(NOW_DATE_FORMAT);
                date = sdf.parse(s);
                builder = builder.sent(SearchTermBuilder.Comparison.LE, date);
            }
        }
        if (simple.getFromReceivedDate() != null) {
            s = simple.getFromReceivedDate();
            if (s.startsWith("now")) {
                long offset = MailConverters.extractOffset(s);
                builder = builder.and(new NowSearchTerm(SearchTermBuilder.Comparison.GE.asNum(), false, offset));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(NOW_DATE_FORMAT);
                date = sdf.parse(s);
                builder = builder.received(SearchTermBuilder.Comparison.GE, date);
            }
        }
        if (simple.getToReceivedDate() != null) {
            s = simple.getToReceivedDate();
            if (s.startsWith("now")) {
                long offset = MailConverters.extractOffset(s);
                builder = builder.and(new NowSearchTerm(SearchTermBuilder.Comparison.LE.asNum(), false, offset));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(NOW_DATE_FORMAT);
                date = sdf.parse(s);
                builder = builder.received(SearchTermBuilder.Comparison.LE, date);
            }
        }
        return builder.build();
    }

    public static SortTerm[] toSortTerm(String sortTerm) {
        String[] sortTerms;
        ArrayList<SortTerm> result = new ArrayList<SortTerm>();
        if (sortTerm == null) {
            return null;
        }
        for (String key : sortTerms = sortTerm.split(",")) {
            if ("arrival".equals(key)) {
                result.add(SortTerm.ARRIVAL);
                continue;
            }
            if ("cc".equals(key)) {
                result.add(SortTerm.CC);
                continue;
            }
            if ("date".equals(key)) {
                result.add(SortTerm.DATE);
                continue;
            }
            if ("from".equals(key)) {
                result.add(SortTerm.FROM);
                continue;
            }
            if ("reverse".equals(key)) {
                result.add(SortTerm.REVERSE);
                continue;
            }
            if ("size".equals(key)) {
                result.add(SortTerm.SIZE);
                continue;
            }
            if ("subject".equals(key)) {
                result.add(SortTerm.SUBJECT);
                continue;
            }
            if (!"to".equals(key)) continue;
            result.add(SortTerm.TO);
        }
        if (!result.isEmpty()) {
            return result.toArray(new SortTerm[0]);
        }
        return null;
    }

    private static long extractOffset(String now) {
        Matcher matcher = NOW_PATTERN.matcher(now);
        if (matcher.matches()) {
            String op = matcher.group(1);
            String remainder = matcher.group(2);
            long offset = TimeUtils.toMilliSeconds(remainder);
            if ("+".equals(op)) {
                return offset;
            }
            return -1L * offset;
        }
        return 0L;
    }
}

