/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import jakarta.mail.Message;
import jakarta.mail.search.SearchTerm;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mail.ContentTypeResolver;
import org.apache.camel.component.mail.DefaultMailUidGenerator;
import org.apache.camel.component.mail.JavaMailSender;
import org.apache.camel.component.mail.MailBinding;
import org.apache.camel.component.mail.MailBoxPostProcessAction;
import org.apache.camel.component.mail.MailComponent;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailConstants;
import org.apache.camel.component.mail.MailConsumer;
import org.apache.camel.component.mail.MailHeaderFilterStrategy;
import org.apache.camel.component.mail.MailMessage;
import org.apache.camel.component.mail.MailProducer;
import org.apache.camel.component.mail.MailUidGenerator;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.eclipse.angus.mail.imap.SortTerm;

@UriEndpoint(firstVersion="1.0.0", scheme="imap,imaps,pop3,pop3s,smtp,smtps", title="IMAP,IMAPS,POP3,POP3S,SMTP,SMTPS", syntax="imap:host:port", alternativeSyntax="imap:username:password@host:port", category={Category.MAIL}, headersClass=MailConstants.class)
public class MailEndpoint
extends ScheduledPollEndpoint
implements HeaderFilterStrategyAware,
EndpointServiceLocation {
    @UriParam(defaultValue="60000", javaType="java.time.Duration", label="consumer,scheduler", description="Milliseconds before the next poll.")
    private long delay = 60000L;
    @UriParam
    private MailConfiguration configuration;
    @UriParam(label="advanced")
    private MailBinding binding;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy = new MailHeaderFilterStrategy();
    @UriParam(label="advanced")
    private ContentTypeResolver contentTypeResolver;
    @UriParam(label="consumer")
    private int maxMessagesPerPoll;
    @UriParam(label="consumer,filter", prefix="searchTerm.", multiValue=true)
    private SearchTerm searchTerm;
    @UriParam(label="consumer,sort")
    private SortTerm[] sortTerm;
    @UriParam(label="consumer,advanced")
    private MailBoxPostProcessAction postProcessAction;
    @UriParam(label="consumer,filter")
    private IdempotentRepository idempotentRepository;
    @UriParam(label="consumer,filter", defaultValue="true")
    private boolean idempotentRepositoryRemoveOnCommit = true;
    @UriParam(label="consumer,advanced")
    private MailUidGenerator mailUidGenerator = new DefaultMailUidGenerator();

    public MailEndpoint() {
        this(null, null, null);
    }

    public MailEndpoint(String endpointUri) {
        this(endpointUri, null, new MailConfiguration());
    }

    public MailEndpoint(String uri, MailComponent component, MailConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
        this.setDelay(60000L);
    }

    @Override
    public String getServiceUrl() {
        if (this.configuration != null) {
            return this.configuration.getProtocol() + ":" + this.configuration.getHost() + ":" + this.configuration.getPort();
        }
        return null;
    }

    @Override
    public String getServiceProtocol() {
        if (this.configuration != null) {
            return this.configuration.getProtocol();
        }
        return null;
    }

    @Override
    public Map<String, String> getServiceMetadata() {
        if (this.configuration != null && this.configuration.getUsername() != null) {
            return Map.of("username", this.configuration.getUsername());
        }
        return null;
    }

    @Override
    public Producer createProducer() throws Exception {
        JavaMailSender sender = this.configuration.getJavaMailSender();
        if (sender == null) {
            sender = this.configuration.createJavaMailSender(this.getCamelContext());
        }
        return this.createProducer(sender);
    }

    public Producer createProducer(JavaMailSender sender) {
        return new MailProducer(this, sender);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.configuration.getProtocol().startsWith("smtp")) {
            throw new IllegalArgumentException("Protocol " + this.configuration.getProtocol() + " cannot be used for a MailConsumer. Please use another protocol such as pop3 or imap.");
        }
        JavaMailSender sender = this.configuration.createJavaMailSender(this.getCamelContext());
        return this.createConsumer(processor, sender);
    }

    public Consumer createConsumer(Processor processor, JavaMailSender sender) throws Exception {
        MailConsumer answer = new MailConsumer(this, processor, sender);
        answer.setHandleFailedMessage(this.configuration.isHandleFailedMessage());
        answer.setSkipFailedMessage(this.configuration.isSkipFailedMessage());
        answer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        this.configureConsumer(answer);
        return answer;
    }

    public Exchange createExchange(Message message) {
        Exchange exchange = super.createExchange();
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        exchange.setIn(new MailMessage(exchange, message, this.getConfiguration().isMapMailMessage()));
        return exchange;
    }

    public MailBinding getBinding() {
        if (this.binding == null) {
            boolean decode = this.getConfiguration() != null && this.getConfiguration().isDecodeFilename();
            boolean mapMailMessage = this.getConfiguration() != null && this.getConfiguration().isMapMailMessage();
            boolean failDuplicate = this.getConfiguration() != null && this.getConfiguration().isFailOnDuplicateFileAttachment();
            String generateMissingAttachmentNames = this.getConfiguration() != null ? this.getConfiguration().getGenerateMissingAttachmentNames() : "never";
            String handleDuplicateAttachmentNames = this.getConfiguration() != null ? this.getConfiguration().getHandleDuplicateAttachmentNames() : "never";
            this.binding = new MailBinding(this.headerFilterStrategy, this.contentTypeResolver, decode, mapMailMessage, failDuplicate, generateMissingAttachmentNames, handleDuplicateAttachmentNames);
        }
        return this.binding;
    }

    public void setBinding(MailBinding binding) {
        this.binding = binding;
    }

    public MailConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MailConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public ContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setContentTypeResolver(ContentTypeResolver contentTypeResolver) {
        this.contentTypeResolver = contentTypeResolver;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public SearchTerm getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(SearchTerm searchTerm) {
        this.searchTerm = searchTerm;
    }

    public SortTerm[] getSortTerm() {
        return this.sortTerm == null ? null : (SortTerm[])this.sortTerm.clone();
    }

    public void setSortTerm(SortTerm[] sortTerm) {
        this.sortTerm = sortTerm == null ? null : (SortTerm[])sortTerm.clone();
    }

    public MailBoxPostProcessAction getPostProcessAction() {
        return this.postProcessAction;
    }

    public void setPostProcessAction(MailBoxPostProcessAction postProcessAction) {
        this.postProcessAction = postProcessAction;
    }

    public IdempotentRepository getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public void setIdempotentRepository(IdempotentRepository idempotentRepository) {
        this.idempotentRepository = idempotentRepository;
    }

    public boolean isIdempotentRepositoryRemoveOnCommit() {
        return this.idempotentRepositoryRemoveOnCommit;
    }

    public void setIdempotentRepositoryRemoveOnCommit(boolean idempotentRepositoryRemoveOnCommit) {
        this.idempotentRepositoryRemoveOnCommit = idempotentRepositoryRemoveOnCommit;
    }

    public MailUidGenerator getMailUidGenerator() {
        return this.mailUidGenerator;
    }

    public void setMailUidGenerator(MailUidGenerator mailUidGenerator) {
        this.mailUidGenerator = mailUidGenerator;
    }

    @Override
    public void setDelay(long delay) {
        super.setDelay(delay);
        this.delay = delay;
    }
}

