/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import jakarta.mail.Message;
import jakarta.mail.Multipart;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.mail.MailConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class MailConvertersLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
        this.registerFallbackConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        MailConvertersLoader.addTypeConverter(registry, InputStream.class, Message.class, false, (type, exchange, value) -> MailConverters.toInputStream((Message)value));
        MailConvertersLoader.addTypeConverter(registry, InputStream.class, Multipart.class, false, (type, exchange, value) -> MailConverters.toInputStream((Multipart)value, exchange));
        MailConvertersLoader.addTypeConverter(registry, String.class, Message.class, false, (type, exchange, value) -> MailConverters.toString((Message)value));
        MailConvertersLoader.addTypeConverter(registry, String.class, Multipart.class, false, (type, exchange, value) -> MailConverters.toString((Multipart)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        MailConvertersLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> MailConverters.convertTo(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter(new SimpleTypeConverter(allowNull, method), canPromote);
    }
}

