/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mail.MailBinding;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class MailMessage
extends DefaultMessage {
    private jakarta.mail.Message originalMailMessage;
    private jakarta.mail.Message mailMessage;
    private boolean mapMailMessage;

    public MailMessage(Exchange exchange, jakarta.mail.Message message, boolean mapMailMessage) {
        super(exchange);
        this.originalMailMessage = this.mailMessage = message;
        this.mapMailMessage = mapMailMessage;
    }

    @Override
    public String toString() {
        return "MailMessage@" + ObjectHelper.getIdentityHashCode(this);
    }

    @Override
    public MailMessage copy() {
        MailMessage answer = (MailMessage)super.copy();
        answer.originalMailMessage = this.originalMailMessage;
        answer.mailMessage = this.mailMessage;
        return answer;
    }

    public jakarta.mail.Message getOriginalMessage() {
        return this.originalMailMessage;
    }

    public jakarta.mail.Message getMessage() {
        return this.mailMessage;
    }

    public void setMessage(jakarta.mail.Message mailMessage) {
        if (this.originalMailMessage == null) {
            this.originalMailMessage = mailMessage;
        }
        this.mailMessage = mailMessage;
    }

    @Override
    public MailMessage newInstance() {
        MailMessage answer = new MailMessage(null, null, this.mapMailMessage);
        answer.setCamelContext(this.getCamelContext());
        return answer;
    }

    @Override
    protected Object createBody() {
        if (this.mailMessage != null) {
            MailBinding binding = ExchangeHelper.getBinding(this.getExchange(), MailBinding.class);
            return binding != null ? binding.extractBodyFromMail(this.getExchange(), this) : null;
        }
        return null;
    }

    @Override
    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.mailMessage != null) {
            try {
                MailBinding binding = ExchangeHelper.getBinding(this.getExchange(), MailBinding.class);
                if (binding != null) {
                    map.putAll(binding.extractHeadersFromMail(this.mailMessage, this.getExchange()));
                }
            }
            catch (MessagingException | IOException e) {
                throw new RuntimeCamelException("Error accessing headers due to: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void copyFrom(Message that) {
        boolean needCopy;
        boolean bl = needCopy = !(that instanceof MailMessage) || ((MailMessage)that).mapMailMessage;
        if (needCopy) {
            super.copyFrom(that);
        } else {
            this.setMessageId(that.getMessageId());
        }
        if (that instanceof MailMessage) {
            MailMessage tmpMailMessage = (MailMessage)that;
            this.originalMailMessage = tmpMailMessage.originalMailMessage;
            this.mailMessage = tmpMailMessage.mailMessage;
            this.mapMailMessage = tmpMailMessage.mapMailMessage;
        }
        if (this.getExchange() == null) {
            this.setExchange(that.getExchange());
        }
    }
}

