/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import java.text.DateFormat;
import java.util.Date;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class MailUtils {
    public static final int DEFAULT_PORT_SMTP = 25;
    public static final int DEFAULT_PORT_SMTPS = 465;
    public static final int DEFAULT_PORT_POP3 = 110;
    public static final int DEFAULT_PORT_POP3S = 995;
    public static final int DEFAULT_PORT_NNTP = 119;
    public static final int DEFAULT_PORT_IMAP = 143;
    public static final int DEFAULT_PORT_IMAPS = 993;
    public static final String PROTOCOL_SMTP = "smtp";
    public static final String PROTOCOL_SMTPS = "smtps";
    public static final String PROTOCOL_POP3 = "pop3";
    public static final String PROTOCOL_POP3S = "pop3s";
    public static final String PROTOCOL_NNTP = "nntp";
    public static final String PROTOCOL_IMAP = "imap";
    public static final String PROTOCOL_IMAPS = "imaps";

    private MailUtils() {
    }

    public static int getDefaultPortForProtocol(String protocol) {
        int port = 25;
        if (protocol != null) {
            port = protocol.equalsIgnoreCase(PROTOCOL_IMAP) ? 143 : (protocol.equalsIgnoreCase(PROTOCOL_IMAPS) ? 993 : (protocol.equalsIgnoreCase(PROTOCOL_NNTP) ? 119 : (protocol.equalsIgnoreCase(PROTOCOL_POP3) ? 110 : (protocol.equalsIgnoreCase(PROTOCOL_POP3S) ? 995 : (protocol.equalsIgnoreCase(PROTOCOL_SMTP) ? 25 : (protocol.equalsIgnoreCase(PROTOCOL_SMTPS) ? 465 : 25))))));
        }
        return port;
    }

    public static String dumpMessage(Message message) {
        if (message == null) {
            return "null";
        }
        try {
            Date receivedDate;
            Date sentDate;
            String subject;
            Address[] to;
            StringBuilder sb = new StringBuilder();
            int number = message.getMessageNumber();
            sb.append("messageNumber=[").append(number).append("]");
            Address[] from = message.getFrom();
            if (from != null) {
                for (Address adr : from) {
                    sb.append(", from=[").append(adr).append("]");
                }
            }
            if ((to = message.getRecipients(Message.RecipientType.TO)) != null) {
                for (Address adr : to) {
                    sb.append(", to=[").append(adr).append("]");
                }
            }
            if ((subject = message.getSubject()) != null) {
                sb.append(", subject=[").append(subject).append("]");
            }
            if ((sentDate = message.getSentDate()) != null) {
                sb.append(", sentDate=[").append(DateFormat.getDateTimeInstance().format(sentDate)).append("]");
            }
            if ((receivedDate = message.getReceivedDate()) != null) {
                sb.append(", receivedDate=[").append(DateFormat.getDateTimeInstance().format(receivedDate)).append("]");
            }
            return sb.toString();
        }
        catch (MessagingException e) {
            return message.toString();
        }
    }

    public static String padContentType(String contentType) {
        StringBuilder sb = new StringBuilder();
        String[] parts = contentType.split(";");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (!ObjectHelper.isNotEmpty(part)) continue;
            part = part.trim();
            sb.append(part);
            if (i >= parts.length - 1) continue;
            sb.append("; ");
        }
        return sb.toString();
    }

    public static String replaceCharSet(String contentType, String charset) {
        String[] parts;
        boolean replaced = false;
        StringBuilder sb = new StringBuilder();
        for (String part : parts = contentType.split(";")) {
            if (!(part = part.trim()).startsWith("charset")) {
                part = part.trim();
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append(part);
                continue;
            }
            if (charset == null) continue;
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append("charset=");
            sb.append(charset);
            replaced = true;
        }
        if (!replaced && charset != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append("charset=");
            sb.append(charset);
        }
        return sb.toString();
    }

    public static String getCharSetFromContentType(String contentType) {
        String[] parts;
        if (contentType == null) {
            return null;
        }
        for (String part : parts = contentType.split(";")) {
            if (!(part = part.trim()).startsWith("charset")) continue;
            return StringHelper.after(part, "charset=");
        }
        return null;
    }
}

