/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mapstruct;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mapstruct.MapstructProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.19.0", scheme="mapstruct", title="MapStruct", syntax="mapstruct:className", remote=false, producerOnly=true, category={Category.TRANSFORMATION})
public class MapstructEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private String className;
    private transient Class<?> clazz;
    @UriParam(defaultValue="true")
    private boolean mandatory = true;

    public MapstructEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new MapstructProducer(this, this.clazz, this.mandatory);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not supported");
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    protected void doBuild() throws Exception {
        ObjectHelper.notNull(this.className, "className");
        this.clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(this.className);
    }
}

