/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class EnumTypeConverter
extends TypeConverterSupport
implements CamelContextAware {
    private CamelContext camelContext;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return this.doConvertTo(type, exchange, value);
    }

    private <T> T doConvertTo(Class<T> type, Exchange exchange, Object value) {
        if (type.isEnum()) {
            TypeConverterRegistry tcr;
            TypeConverterRegistry typeConverterRegistry = tcr = this.camelContext != null ? this.camelContext.getTypeConverterRegistry() : null;
            if (tcr != null) {
                Class<?> clazz;
                Class<?> fromType = value.getClass();
                TypeConverter tc = tcr.lookup(type, value.getClass());
                if (tc == null && fromType != (clazz = ObjectHelper.convertWrapperTypeToPrimitiveType(fromType))) {
                    tc = tcr.lookup(type, clazz);
                }
                if (tc != null) {
                    return tc.convertTo(type, exchange, value);
                }
            }
            String text = value.toString().trim();
            Class<T> enumClass = type;
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                if (!enumValue.name().equalsIgnoreCase(text)) continue;
                return type.cast(enumValue);
            }
            String string = StringHelper.asEnumConstantValue(text);
            if (!string.equals(text)) {
                for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                    if (!enumValue.name().equalsIgnoreCase(string)) continue;
                    return type.cast(enumValue);
                }
            }
            throw new IllegalArgumentException("Enum class " + String.valueOf(type) + " does not have any constant with value: " + text);
        }
        return null;
    }
}

