/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics.spi;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.InstrumentedScheduledExecutorService;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.support.DefaultThreadPoolFactory;
import org.apache.camel.util.ObjectHelper;

public class InstrumentedThreadPoolFactory
implements ThreadPoolFactory {
    private MetricRegistry metricRegistry;
    private ThreadPoolFactory threadPoolFactory;

    public InstrumentedThreadPoolFactory(MetricRegistry metricRegistry) {
        this(metricRegistry, new DefaultThreadPoolFactory());
    }

    public InstrumentedThreadPoolFactory(MetricRegistry metricRegistry, ThreadPoolFactory threadPoolFactory) {
        ObjectHelper.notNull(metricRegistry, "metricRegistry", this);
        ObjectHelper.notNull(threadPoolFactory, "threadPoolFactory", this);
        this.metricRegistry = metricRegistry;
        this.threadPoolFactory = threadPoolFactory;
    }

    @Override
    public ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new InstrumentedExecutorService(this.threadPoolFactory.newCachedThreadPool(threadFactory), this.metricRegistry);
    }

    @Override
    public ExecutorService newThreadPool(ThreadPoolProfile profile, ThreadFactory threadFactory) {
        return new InstrumentedExecutorService(this.threadPoolFactory.newThreadPool(profile, threadFactory), this.metricRegistry, profile.getId());
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(ThreadPoolProfile profile, ThreadFactory threadFactory) {
        return new InstrumentedScheduledExecutorService(this.threadPoolFactory.newScheduledThreadPool(profile, threadFactory), this.metricRegistry, profile.getId());
    }
}

