/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.component.micrometer.AbstractMicrometerProducer;
import org.apache.camel.component.micrometer.MicrometerEndpoint;

public class DistributionSummaryProducer
extends AbstractMicrometerProducer<DistributionSummary> {
    public DistributionSummaryProducer(MicrometerEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected Function<MeterRegistry, DistributionSummary> registrar(String name, String description, Iterable<Tag> tags) {
        return meterRegistry -> DistributionSummary.builder(name).description(description).tags(tags).register((MeterRegistry)meterRegistry);
    }

    @Override
    protected void doProcess(Exchange exchange, MicrometerEndpoint endpoint, DistributionSummary summary) {
        Double value = this.simple(exchange, endpoint.getValue(), Double.class);
        Double finalValue = this.getDoubleHeader(exchange.getIn(), "CamelMetricsHistogramValue", value);
        if (finalValue != null) {
            summary.record(finalValue);
        }
    }
}

