/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.minio.MinioComponentVerifierExtension;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.component.minio.MinioEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="minio")
public class MinioComponent
extends HealthCheckComponent {
    @Metadata
    private MinioConfiguration configuration = new MinioConfiguration();

    public MinioComponent() {
        this(null);
    }

    public MinioComponent(CamelContext context) {
        super(context);
        this.registerExtension(new MinioComponentVerifierExtension());
    }

    @Override
    protected MinioEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty(remaining) || remaining.isBlank()) {
            throw new IllegalArgumentException("Bucket name must be specified.");
        }
        MinioConfiguration configuration = ObjectHelper.isNotEmpty(this.configuration) ? this.configuration.copy() : new MinioConfiguration();
        configuration.setBucketName(remaining);
        MinioEndpoint endpoint = new MinioEndpoint(uri, this, configuration);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    public MinioConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MinioConfiguration configuration) {
        this.configuration = configuration;
    }
}

