/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.SetBucketPolicyArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.minio.MinioChecks;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.component.minio.MinioConstants;
import org.apache.camel.component.minio.MinioConsumer;
import org.apache.camel.component.minio.MinioProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.5.0", scheme="minio", title="Minio", syntax="minio:bucketName", category={Category.CLOUD, Category.FILE}, headersClass=MinioConstants.class)
public class MinioEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    private static final Logger LOG = LoggerFactory.getLogger(MinioEndpoint.class);
    private MinioClient minioClient;
    @UriParam
    private MinioConfiguration configuration;

    public MinioEndpoint(String uri, Component component, MinioConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    @Override
    public String getServiceUrl() {
        return this.configuration.getEndpoint();
    }

    @Override
    public String getServiceProtocol() {
        return "rest";
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        MinioConsumer minioConsumer = new MinioConsumer(this, processor);
        this.configureConsumer(minioConsumer);
        minioConsumer.setMaxMessagesPerPoll(this.configuration.getMaxMessagesPerPoll());
        return minioConsumer;
    }

    @Override
    public Producer createProducer() {
        return new MinioProducer(this);
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.minioClient = ObjectHelper.isNotEmpty(this.getConfiguration().getMinioClient()) ? this.getConfiguration().getMinioClient() : this.createMinioClient();
        String objectName = this.getConfiguration().getObjectName();
        if (ObjectHelper.isNotEmpty(objectName)) {
            LOG.trace("Object name {} requested, so skipping bucket check...", (Object)objectName);
            return;
        }
        String bucketName = this.getConfiguration().getBucketName();
        LOG.trace("Querying whether bucket {} already exists...", (Object)bucketName);
        if (this.bucketExists(bucketName)) {
            LOG.trace("Bucket {} already exists", (Object)bucketName);
        } else if (this.getConfiguration().isAutoCreateBucket()) {
            LOG.trace("AutoCreateBucket set to true, Creating bucket {}...", (Object)bucketName);
            this.makeBucket(bucketName);
            LOG.trace("Bucket created");
        }
        if (ObjectHelper.isNotEmpty(this.getConfiguration().getPolicy())) {
            LOG.trace("Updating bucket {} with policy {}", (Object)bucketName, (Object)this.configuration.getPolicy());
            this.setBucketPolicy(bucketName);
            LOG.trace("Bucket policy updated");
        }
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
    }

    public MinioConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MinioConfiguration configuration) {
        this.configuration = configuration;
    }

    public MinioClient getMinioClient() {
        return this.minioClient;
    }

    public void setMinioClient(MinioClient minioClient) {
        this.minioClient = minioClient;
    }

    MinioClient createMinioClient() {
        if (ObjectHelper.isNotEmpty(this.configuration.getEndpoint())) {
            MinioClient.Builder minioClientRequest = MinioClient.builder();
            if (ObjectHelper.isNotEmpty(this.configuration.getProxyPort())) {
                minioClientRequest.endpoint(this.configuration.getEndpoint(), this.configuration.getProxyPort(), this.configuration.isSecure());
            } else {
                minioClientRequest.endpoint(this.configuration.getEndpoint());
            }
            if (ObjectHelper.isNotEmpty(this.configuration.getAccessKey()) && ObjectHelper.isNotEmpty(this.configuration.getSecretKey())) {
                minioClientRequest.credentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            }
            if (ObjectHelper.isNotEmpty(this.configuration.getRegion())) {
                minioClientRequest.region(this.configuration.getRegion());
            }
            if (ObjectHelper.isNotEmpty(this.configuration.getCustomHttpClient())) {
                minioClientRequest.httpClient(this.configuration.getCustomHttpClient());
            }
            return minioClientRequest.build();
        }
        throw new IllegalArgumentException("Endpoint must be specified");
    }

    private boolean bucketExists(String bucketName) throws Exception {
        return this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
    }

    private void makeBucket(String bucketName) throws Exception {
        MakeBucketArgs.Builder makeBucketRequest = ((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).objectLock(this.getConfiguration().isObjectLock());
        if (ObjectHelper.isNotEmpty(this.getConfiguration().getRegion())) {
            makeBucketRequest.region(this.getConfiguration().getRegion());
        }
        this.minioClient.makeBucket((MakeBucketArgs)makeBucketRequest.build());
    }

    private void setBucketPolicy(String bucketName) throws Exception {
        LOG.trace("Updating bucket {} with policy...", (Object)bucketName);
        this.minioClient.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucketName)).config(this.getConfiguration().getPolicy()).build());
        LOG.trace("Bucket policy updated");
    }

    void getObjectStat(String objectName, Message message) throws Exception {
        String bucketName = this.getConfiguration().getBucketName();
        StatObjectArgs.Builder statObjectRequest = (StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName);
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getServerSideEncryptionCustomerKey, statObjectRequest::ssec);
        MinioChecks.checkLengthAndSetConfig(this.getConfiguration()::getOffset, statObjectRequest::offset);
        MinioChecks.checkLengthAndSetConfig(this.getConfiguration()::getLength, statObjectRequest::length);
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getVersionId, statObjectRequest::versionId);
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getMatchETag, statObjectRequest::matchETag);
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getNotMatchETag, statObjectRequest::notMatchETag);
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getModifiedSince, statObjectRequest::modifiedSince);
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getUnModifiedSince, statObjectRequest::unmodifiedSince);
        StatObjectResponse stat = this.minioClient.statObject((StatObjectArgs)statObjectRequest.build());
        message.setHeader("CamelMinioObjectName", stat.object());
        message.setHeader("CamelMinioBucketName", stat.bucket());
        message.setHeader("CamelMinioETag", stat.etag());
        message.setHeader("CamelMinioLastModified", stat.headers().get("last-modified"));
        message.setHeader("CamelMinioVersionId", stat.headers().get("x-amz-version-id"));
        message.setHeader("CamelMinioContentType", stat.contentType());
        message.setHeader("CamelMinioContentLength", stat.size());
        message.setHeader("CamelMinioContentEncoding", stat.headers().get("content-encoding"));
        message.setHeader("CamelMinioContentDisposition", stat.headers().get("content-disposition"));
        message.setHeader("CamelMinioContentControl", stat.headers().get("cache-control"));
        message.setHeader("CamelMinioServerSideEncryption", stat.headers().get("x-amz-server-side-encryption"));
        message.setHeader("CamelMinioExpirationTime", stat.headers().get("x-amz-expiration"));
        message.setHeader("CamelMinioReplicationStatus", stat.headers().get("x-amz-replication-status"));
        message.setHeader("CamelMinioStorageClass", stat.headers().get("x-amz-storage-class"));
    }
}

