/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import io.minio.MinioClient;
import io.minio.ServerSideEncryption;
import io.minio.ServerSideEncryptionCustomerKey;
import java.time.ZonedDateTime;
import okhttp3.OkHttpClient;
import org.apache.camel.CamelContext;
import org.apache.camel.component.minio.MinioComponent;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.component.minio.MinioOperations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class MinioComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private MinioConfiguration getOrCreateConfiguration(MinioComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new MinioConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        MinioComponent target = (MinioComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "autoclosebody": 
            case "autoCloseBody": {
                this.getOrCreateConfiguration(target).setAutoCloseBody(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                this.getOrCreateConfiguration(target).setAutoCreateBucket(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bypassgovernancemode": 
            case "bypassGovernanceMode": {
                this.getOrCreateConfiguration(target).setBypassGovernanceMode(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(MinioComponentConfigurer.property(camelContext, MinioConfiguration.class, value));
                return true;
            }
            case "customhttpclient": 
            case "customHttpClient": {
                this.getOrCreateConfiguration(target).setCustomHttpClient(MinioComponentConfigurer.property(camelContext, OkHttpClient.class, value));
                return true;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                this.getOrCreateConfiguration(target).setDeleteAfterRead(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                this.getOrCreateConfiguration(target).setDeleteAfterWrite(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "delimiter": {
                this.getOrCreateConfiguration(target).setDelimiter(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "destinationbucketname": 
            case "destinationBucketName": {
                this.getOrCreateConfiguration(target).setDestinationBucketName(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "destinationobjectname": 
            case "destinationObjectName": {
                this.getOrCreateConfiguration(target).setDestinationObjectName(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "endpoint": {
                this.getOrCreateConfiguration(target).setEndpoint(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                target.setHealthCheckConsumerEnabled(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                target.setHealthCheckProducerEnabled(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "includebody": 
            case "includeBody": {
                this.getOrCreateConfiguration(target).setIncludeBody(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "includefolders": 
            case "includeFolders": {
                this.getOrCreateConfiguration(target).setIncludeFolders(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "includeusermetadata": 
            case "includeUserMetadata": {
                this.getOrCreateConfiguration(target).setIncludeUserMetadata(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "includeversions": 
            case "includeVersions": {
                this.getOrCreateConfiguration(target).setIncludeVersions(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "keyname": 
            case "keyName": {
                this.getOrCreateConfiguration(target).setKeyName(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "length": {
                this.getOrCreateConfiguration(target).setLength(MinioComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "matchetag": 
            case "matchETag": {
                this.getOrCreateConfiguration(target).setMatchETag(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "maxconnections": 
            case "maxConnections": {
                this.getOrCreateConfiguration(target).setMaxConnections(MinioComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                this.getOrCreateConfiguration(target).setMaxMessagesPerPoll(MinioComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "minioclient": 
            case "minioClient": {
                this.getOrCreateConfiguration(target).setMinioClient(MinioComponentConfigurer.property(camelContext, MinioClient.class, value));
                return true;
            }
            case "modifiedsince": 
            case "modifiedSince": {
                this.getOrCreateConfiguration(target).setModifiedSince(MinioComponentConfigurer.property(camelContext, ZonedDateTime.class, value));
                return true;
            }
            case "moveafterread": 
            case "moveAfterRead": {
                this.getOrCreateConfiguration(target).setMoveAfterRead(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "notmatchetag": 
            case "notMatchETag": {
                this.getOrCreateConfiguration(target).setNotMatchETag(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "objectlock": 
            case "objectLock": {
                this.getOrCreateConfiguration(target).setObjectLock(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "objectname": 
            case "objectName": {
                this.getOrCreateConfiguration(target).setObjectName(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "offset": {
                this.getOrCreateConfiguration(target).setOffset(MinioComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation(MinioComponentConfigurer.property(camelContext, MinioOperations.class, value));
                return true;
            }
            case "pojorequest": 
            case "pojoRequest": {
                this.getOrCreateConfiguration(target).setPojoRequest(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "policy": {
                this.getOrCreateConfiguration(target).setPolicy(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "prefix": {
                this.getOrCreateConfiguration(target).setPrefix(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort(MinioComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "recursive": {
                this.getOrCreateConfiguration(target).setRecursive(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "secure": {
                this.getOrCreateConfiguration(target).setSecure(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "serversideencryption": 
            case "serverSideEncryption": {
                this.getOrCreateConfiguration(target).setServerSideEncryption(MinioComponentConfigurer.property(camelContext, ServerSideEncryption.class, value));
                return true;
            }
            case "serversideencryptioncustomerkey": 
            case "serverSideEncryptionCustomerKey": {
                this.getOrCreateConfiguration(target).setServerSideEncryptionCustomerKey(MinioComponentConfigurer.property(camelContext, ServerSideEncryptionCustomerKey.class, value));
                return true;
            }
            case "startafter": 
            case "startAfter": {
                this.getOrCreateConfiguration(target).setStartAfter(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "storageclass": 
            case "storageClass": {
                this.getOrCreateConfiguration(target).setStorageClass(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "unmodifiedsince": 
            case "unModifiedSince": {
                this.getOrCreateConfiguration(target).setUnModifiedSince(MinioComponentConfigurer.property(camelContext, ZonedDateTime.class, value));
                return true;
            }
            case "useversion1": 
            case "useVersion1": {
                this.getOrCreateConfiguration(target).setUseVersion1(MinioComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "versionid": 
            case "versionId": {
                this.getOrCreateConfiguration(target).setVersionId(MinioComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"minioClient"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "autoclosebody": 
            case "autoCloseBody": {
                return Boolean.TYPE;
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                return Boolean.TYPE;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "bypassgovernancemode": 
            case "bypassGovernanceMode": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return MinioConfiguration.class;
            }
            case "customhttpclient": 
            case "customHttpClient": {
                return OkHttpClient.class;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return Boolean.TYPE;
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                return Boolean.TYPE;
            }
            case "delimiter": {
                return String.class;
            }
            case "destinationbucketname": 
            case "destinationBucketName": {
                return String.class;
            }
            case "destinationobjectname": 
            case "destinationObjectName": {
                return String.class;
            }
            case "endpoint": {
                return String.class;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return Boolean.TYPE;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return Boolean.TYPE;
            }
            case "includebody": 
            case "includeBody": {
                return Boolean.TYPE;
            }
            case "includefolders": 
            case "includeFolders": {
                return Boolean.TYPE;
            }
            case "includeusermetadata": 
            case "includeUserMetadata": {
                return Boolean.TYPE;
            }
            case "includeversions": 
            case "includeVersions": {
                return Boolean.TYPE;
            }
            case "keyname": 
            case "keyName": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "length": {
                return Long.TYPE;
            }
            case "matchetag": 
            case "matchETag": {
                return String.class;
            }
            case "maxconnections": 
            case "maxConnections": {
                return Integer.TYPE;
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                return Integer.TYPE;
            }
            case "minioclient": 
            case "minioClient": {
                return MinioClient.class;
            }
            case "modifiedsince": 
            case "modifiedSince": {
                return ZonedDateTime.class;
            }
            case "moveafterread": 
            case "moveAfterRead": {
                return Boolean.TYPE;
            }
            case "notmatchetag": 
            case "notMatchETag": {
                return String.class;
            }
            case "objectlock": 
            case "objectLock": {
                return Boolean.TYPE;
            }
            case "objectname": 
            case "objectName": {
                return String.class;
            }
            case "offset": {
                return Long.TYPE;
            }
            case "operation": {
                return MinioOperations.class;
            }
            case "pojorequest": 
            case "pojoRequest": {
                return Boolean.TYPE;
            }
            case "policy": {
                return String.class;
            }
            case "prefix": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "recursive": {
                return Boolean.TYPE;
            }
            case "region": {
                return String.class;
            }
            case "secretkey": 
            case "secretKey": {
                return String.class;
            }
            case "secure": {
                return Boolean.TYPE;
            }
            case "serversideencryption": 
            case "serverSideEncryption": {
                return ServerSideEncryption.class;
            }
            case "serversideencryptioncustomerkey": 
            case "serverSideEncryptionCustomerKey": {
                return ServerSideEncryptionCustomerKey.class;
            }
            case "startafter": 
            case "startAfter": {
                return String.class;
            }
            case "storageclass": 
            case "storageClass": {
                return String.class;
            }
            case "unmodifiedsince": 
            case "unModifiedSince": {
                return ZonedDateTime.class;
            }
            case "useversion1": 
            case "useVersion1": {
                return Boolean.TYPE;
            }
            case "versionid": 
            case "versionId": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        MinioComponent target = (MinioComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "autoclosebody": 
            case "autoCloseBody": {
                return this.getOrCreateConfiguration(target).isAutoCloseBody();
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                return this.getOrCreateConfiguration(target).isAutoCreateBucket();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "bypassgovernancemode": 
            case "bypassGovernanceMode": {
                return this.getOrCreateConfiguration(target).isBypassGovernanceMode();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "customhttpclient": 
            case "customHttpClient": {
                return this.getOrCreateConfiguration(target).getCustomHttpClient();
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return this.getOrCreateConfiguration(target).isDeleteAfterRead();
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                return this.getOrCreateConfiguration(target).isDeleteAfterWrite();
            }
            case "delimiter": {
                return this.getOrCreateConfiguration(target).getDelimiter();
            }
            case "destinationbucketname": 
            case "destinationBucketName": {
                return this.getOrCreateConfiguration(target).getDestinationBucketName();
            }
            case "destinationobjectname": 
            case "destinationObjectName": {
                return this.getOrCreateConfiguration(target).getDestinationObjectName();
            }
            case "endpoint": {
                return this.getOrCreateConfiguration(target).getEndpoint();
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return target.isHealthCheckConsumerEnabled();
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return target.isHealthCheckProducerEnabled();
            }
            case "includebody": 
            case "includeBody": {
                return this.getOrCreateConfiguration(target).isIncludeBody();
            }
            case "includefolders": 
            case "includeFolders": {
                return this.getOrCreateConfiguration(target).isIncludeFolders();
            }
            case "includeusermetadata": 
            case "includeUserMetadata": {
                return this.getOrCreateConfiguration(target).isIncludeUserMetadata();
            }
            case "includeversions": 
            case "includeVersions": {
                return this.getOrCreateConfiguration(target).isIncludeVersions();
            }
            case "keyname": 
            case "keyName": {
                return this.getOrCreateConfiguration(target).getKeyName();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "length": {
                return this.getOrCreateConfiguration(target).getLength();
            }
            case "matchetag": 
            case "matchETag": {
                return this.getOrCreateConfiguration(target).getMatchETag();
            }
            case "maxconnections": 
            case "maxConnections": {
                return this.getOrCreateConfiguration(target).getMaxConnections();
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                return this.getOrCreateConfiguration(target).getMaxMessagesPerPoll();
            }
            case "minioclient": 
            case "minioClient": {
                return this.getOrCreateConfiguration(target).getMinioClient();
            }
            case "modifiedsince": 
            case "modifiedSince": {
                return this.getOrCreateConfiguration(target).getModifiedSince();
            }
            case "moveafterread": 
            case "moveAfterRead": {
                return this.getOrCreateConfiguration(target).isMoveAfterRead();
            }
            case "notmatchetag": 
            case "notMatchETag": {
                return this.getOrCreateConfiguration(target).getNotMatchETag();
            }
            case "objectlock": 
            case "objectLock": {
                return this.getOrCreateConfiguration(target).isObjectLock();
            }
            case "objectname": 
            case "objectName": {
                return this.getOrCreateConfiguration(target).getObjectName();
            }
            case "offset": {
                return this.getOrCreateConfiguration(target).getOffset();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "pojorequest": 
            case "pojoRequest": {
                return this.getOrCreateConfiguration(target).isPojoRequest();
            }
            case "policy": {
                return this.getOrCreateConfiguration(target).getPolicy();
            }
            case "prefix": {
                return this.getOrCreateConfiguration(target).getPrefix();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "recursive": {
                return this.getOrCreateConfiguration(target).isRecursive();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "secure": {
                return this.getOrCreateConfiguration(target).isSecure();
            }
            case "serversideencryption": 
            case "serverSideEncryption": {
                return this.getOrCreateConfiguration(target).getServerSideEncryption();
            }
            case "serversideencryptioncustomerkey": 
            case "serverSideEncryptionCustomerKey": {
                return this.getOrCreateConfiguration(target).getServerSideEncryptionCustomerKey();
            }
            case "startafter": 
            case "startAfter": {
                return this.getOrCreateConfiguration(target).getStartAfter();
            }
            case "storageclass": 
            case "storageClass": {
                return this.getOrCreateConfiguration(target).getStorageClass();
            }
            case "unmodifiedsince": 
            case "unModifiedSince": {
                return this.getOrCreateConfiguration(target).getUnModifiedSince();
            }
            case "useversion1": 
            case "useVersion1": {
                return this.getOrCreateConfiguration(target).isUseVersion1();
            }
            case "versionid": 
            case "versionId": {
                return this.getOrCreateConfiguration(target).getVersionId();
            }
        }
        return null;
    }
}

