/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import io.minio.MinioClient;
import io.minio.errors.MinioException;
import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.util.ObjectHelper;

public class MinioComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    public MinioComponentVerifierExtension() {
        this("minio");
    }

    public MinioComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    @Override
    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption(parameters, "accessKey")).error(ResultErrorHelper.requiresOption(parameters, "secretKey")).error(ResultErrorHelper.requiresOption(parameters, "region"));
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    @Override
    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.CONNECTIVITY);
        try {
            MinioConfiguration configuration = this.setProperties(new MinioConfiguration(), parameters);
            MinioClient.Builder clientBuilderRequest = MinioClient.builder();
            if (ObjectHelper.isEmpty(configuration.getEndpoint())) {
                ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER, "The service endpoint has not defined");
                return builder.error(errorBuilder.build()).build();
            }
            if (ObjectHelper.isNotEmpty(configuration.getProxyPort())) {
                clientBuilderRequest.endpoint(configuration.getEndpoint(), configuration.getProxyPort(), configuration.isSecure());
            } else {
                clientBuilderRequest.endpoint(configuration.getEndpoint());
            }
            if (ObjectHelper.isNotEmpty(configuration.getRegion())) {
                clientBuilderRequest.region(configuration.getRegion());
            }
            if (ObjectHelper.isNotEmpty(configuration.getAccessKey()) && ObjectHelper.isNotEmpty(configuration.getSecretKey())) {
                clientBuilderRequest.credentials(configuration.getAccessKey(), configuration.getSecretKey());
            }
            MinioClient client = clientBuilderRequest.build();
            client.listBuckets();
        }
        catch (MinioException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, e.getMessage()).detail("minio_exception_message", (Object)e.getMessage()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)e.getClass().getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
            builder.error(errorBuilder.build());
        }
        catch (Exception e) {
            builder.error(ResultErrorBuilder.withException(e).build());
        }
        return builder.build();
    }
}

