/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.component.minio.MinioEndpoint;
import org.apache.camel.component.minio.MinioOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MinioProducer.class);

    public MinioProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        MinioOperations operation = this.determineOperation(exchange);
        MinioClient minioClient = this.getEndpoint().getMinioClient();
        if (ObjectHelper.isEmpty(operation)) {
            this.putObject(minioClient, exchange);
        } else {
            switch (operation) {
                case copyObject: {
                    this.copyObject(minioClient, exchange);
                    break;
                }
                case deleteObject: {
                    this.deleteObject(minioClient, exchange);
                    break;
                }
                case deleteObjects: {
                    this.deleteObjects(minioClient, exchange);
                    break;
                }
                case listBuckets: {
                    this.listBuckets(minioClient, exchange);
                    break;
                }
                case deleteBucket: {
                    this.deleteBucket(minioClient, exchange);
                    break;
                }
                case listObjects: {
                    this.listObjects(minioClient, exchange);
                    break;
                }
                case getObject: {
                    this.getObject(minioClient, exchange);
                    break;
                }
                case getPartialObject: {
                    this.getPartialObject(minioClient, exchange);
                    break;
                }
                case createDownloadLink: {
                    this.createPresignedUrl(minioClient, exchange, Method.GET);
                    break;
                }
                case createUploadLink: {
                    this.createPresignedUrl(minioClient, exchange, Method.PUT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(MinioClient minioClient, Exchange exchange) throws Exception {
        block11: {
            block10: {
                if (!this.getConfiguration().isPojoRequest()) break block10;
                PutObjectArgs.Builder payload = exchange.getIn().getMandatoryBody(PutObjectArgs.Builder.class);
                if (ObjectHelper.isNotEmpty(payload)) {
                    ObjectWriteResponse putObjectResult = minioClient.putObject((PutObjectArgs)payload.build());
                    Message message = MinioProducer.getMessageForResponse(exchange);
                    message.setHeader("CamelMinioETag", putObjectResult.etag());
                    if (ObjectHelper.isNotEmpty(putObjectResult.versionId())) {
                        message.setHeader("CamelMinioVersionId", putObjectResult.versionId());
                    }
                }
                break block11;
            }
            String bucketName = this.determineBucketName(exchange);
            String objectName = this.determineObjectName(exchange);
            Map<String, String> objectMetadata = this.determineMetadata(exchange);
            Map<String, String> extraHeaders = this.determineExtraHeaders(exchange);
            long contentLength = Long.parseLong(objectMetadata.getOrDefault("Content-Length", "-1"));
            Object object = exchange.getIn().getMandatoryBody();
            InputStream inputStream2 = null;
            File filePayload = null;
            try {
                if (object instanceof WrappedFile) {
                    object = ((WrappedFile)object).getFile();
                }
                if (object instanceof File) {
                    filePayload = (File)object;
                    inputStream2 = new FileInputStream(filePayload);
                    contentLength = filePayload.length();
                } else {
                    inputStream2 = exchange.getMessage().getMandatoryBody(InputStream.class);
                    if (contentLength <= 0L && (contentLength = this.determineLengthInputStream(inputStream2)) == -1L) {
                        LOG.debug("The content length is not defined. It needs to be determined by reading the data into memory");
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IOHelper.copyAndCloseInput(inputStream2, baos);
                        byte[] arr = baos.toByteArray();
                        contentLength = arr.length;
                        inputStream2 = new ByteArrayInputStream(arr);
                    }
                }
                if (contentLength > 0L) {
                    objectMetadata.put("Content-Length", String.valueOf(contentLength));
                }
                this.doPutObject(exchange, bucketName, objectName, objectMetadata, extraHeaders, inputStream2, contentLength);
            }
            catch (Throwable throwable) {
                IOHelper.close(inputStream2);
                throw throwable;
            }
            IOHelper.close((Closeable)inputStream2);
            if (this.getConfiguration().isDeleteAfterWrite() && ObjectHelper.isNotEmpty(filePayload)) {
                FileUtil.deleteFile(filePayload);
            }
        }
    }

    private void doPutObject(Exchange exchange, String bucketName, String objectName, Map<String, String> objectMetadata, Map<String, String> extraHeaders, InputStream inputStream2, long contentLength) throws IOException, ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, NoSuchAlgorithmException, ServerException, XmlParserException {
        PutObjectArgs.Builder putObjectRequest = (PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().stream(inputStream2, contentLength, -1L).bucket(bucketName)).object(objectName)).userMetadata(objectMetadata);
        if (!extraHeaders.isEmpty()) {
            putObjectRequest.extraHeaders(extraHeaders);
        }
        LOG.trace("Put object from exchange...");
        ObjectWriteResponse putObjectResult = this.getEndpoint().getMinioClient().putObject((PutObjectArgs)putObjectRequest.build());
        LOG.trace("Received result...");
        Message message = MinioProducer.getMessageForResponse(exchange);
        message.setHeader("CamelMinioETag", putObjectResult.etag());
        if (ObjectHelper.isNotEmpty(putObjectResult.versionId())) {
            message.setHeader("CamelMinioVersionId", putObjectResult.versionId());
        }
    }

    private Map<String, String> determineExtraHeaders(Exchange exchange) {
        String cannedAcl;
        HashMap<String, String> extraHeaders = new HashMap<String, String>();
        String storageClass = this.determineStorageClass(exchange);
        if (ObjectHelper.isNotEmpty(storageClass)) {
            extraHeaders.put("X-Amz-Storage-Class", storageClass);
        }
        if (ObjectHelper.isNotEmpty(cannedAcl = exchange.getIn().getHeader("CamelMinioCannedAcl", String.class))) {
            extraHeaders.put("x-amz-acl", cannedAcl);
        }
        return extraHeaders;
    }

    private void copyObject(MinioClient minioClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            CopyObjectArgs.Builder payload = exchange.getIn().getMandatoryBody(CopyObjectArgs.Builder.class);
            if (ObjectHelper.isNotEmpty(payload)) {
                ObjectWriteResponse result = minioClient.copyObject((CopyObjectArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody(result);
            }
        } else {
            String bucketName = this.determineBucketName(exchange);
            String sourceKey = this.determineObjectName(exchange);
            String destinationKey = exchange.getIn().getHeader("CamelMinioDestinationObjectName", String.class);
            String destinationBucketName = exchange.getIn().getHeader("CamelMinioDestinationBucketName", String.class);
            if (ObjectHelper.isEmpty(destinationBucketName)) {
                throw new IllegalArgumentException("Bucket Name Destination must be specified for copyObject Operation");
            }
            if (ObjectHelper.isEmpty(destinationKey)) {
                throw new IllegalArgumentException("Destination Key must be specified for copyObject Operation");
            }
            CopySource.Builder copySourceBuilder = (CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(bucketName)).object(sourceKey);
            CopyObjectArgs.Builder copyObjectRequest = ((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(destinationBucketName)).object(destinationKey)).source((CopySource)copySourceBuilder.build());
            ObjectWriteResponse copyObjectResult = minioClient.copyObject((CopyObjectArgs)copyObjectRequest.build());
            Message message = MinioProducer.getMessageForResponse(exchange);
            if (ObjectHelper.isNotEmpty(copyObjectResult.versionId())) {
                message.setHeader("CamelMinioVersionId", copyObjectResult.versionId());
            }
        }
    }

    private void deleteObject(MinioClient minioClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            RemoveObjectArgs.Builder payload = exchange.getIn().getMandatoryBody(RemoveObjectArgs.Builder.class);
            if (ObjectHelper.isNotEmpty(payload)) {
                minioClient.removeObject((RemoveObjectArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody(true);
            }
        } else {
            String bucketName = this.determineBucketName(exchange);
            String sourceKey = this.determineObjectName(exchange);
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(sourceKey)).build());
            Message message = MinioProducer.getMessageForResponse(exchange);
            message.setBody(true);
        }
    }

    private void deleteObjects(MinioClient minioClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            RemoveObjectsArgs.Builder payload = exchange.getIn().getMandatoryBody(RemoveObjectsArgs.Builder.class);
            if (ObjectHelper.isNotEmpty(payload)) {
                minioClient.removeObjects((RemoveObjectsArgs)payload.build()).iterator().hasNext();
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody(true);
            }
        } else {
            throw new IllegalArgumentException("Cannot delete multiple objects without a POJO request");
        }
    }

    private void listBuckets(MinioClient minioClient, Exchange exchange) throws Exception {
        List<Bucket> bucketsList = minioClient.listBuckets();
        Message message = MinioProducer.getMessageForResponse(exchange);
        message.setBody(bucketsList.iterator());
    }

    private void deleteBucket(MinioClient minioClient, Exchange exchange) throws Exception {
        String bucketName = this.determineBucketName(exchange);
        if (this.getConfiguration().isPojoRequest()) {
            RemoveBucketArgs.Builder payload = exchange.getIn().getMandatoryBody(RemoveBucketArgs.Builder.class);
            if (ObjectHelper.isNotEmpty(payload)) {
                minioClient.removeBucket((RemoveBucketArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody("ok");
            }
        } else {
            minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
            Message message = MinioProducer.getMessageForResponse(exchange);
            message.setBody("ok");
        }
    }

    private void getObject(MinioClient minioClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            GetObjectArgs.Builder payload = exchange.getIn().getMandatoryBody(GetObjectArgs.Builder.class);
            if (ObjectHelper.isNotEmpty(payload)) {
                GetObjectResponse respond = minioClient.getObject((GetObjectArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody(respond);
            }
        } else {
            String bucketName = this.determineBucketName(exchange);
            String sourceKey = this.determineObjectName(exchange);
            GetObjectResponse respond = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(sourceKey)).build());
            Message message = MinioProducer.getMessageForResponse(exchange);
            message.setBody(respond);
        }
    }

    private void getPartialObject(MinioClient minioClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            GetObjectArgs.Builder payload = exchange.getIn().getMandatoryBody(GetObjectArgs.Builder.class);
            if (ObjectHelper.isNotEmpty(payload)) {
                GetObjectResponse respond = minioClient.getObject((GetObjectArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody(respond);
            }
        } else {
            String bucketName = this.determineBucketName(exchange);
            String sourceKey = this.determineObjectName(exchange);
            String offset = exchange.getIn().getHeader("CamelMinioOffset", String.class);
            String length = exchange.getIn().getHeader("CamelMinioLength", String.class);
            if (ObjectHelper.isEmpty(offset) || ObjectHelper.isEmpty(length)) {
                throw new IllegalArgumentException("A Offset and length header must be configured to perform a partial get operation.");
            }
            GetObjectResponse respond = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(sourceKey)).offset(Long.parseLong(offset))).length(Long.parseLong(length))).build());
            Message message = MinioProducer.getMessageForResponse(exchange);
            message.setBody(respond);
        }
    }

    private void listObjects(MinioClient minioClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            ListObjectsArgs.Builder payload = exchange.getIn().getMandatoryBody(ListObjectsArgs.Builder.class);
            if (ObjectHelper.isNotEmpty(payload)) {
                Iterable<Result<Item>> objectList = minioClient.listObjects((ListObjectsArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody(objectList);
            }
        } else {
            String bucketName = this.determineBucketName(exchange);
            Iterable<Result<Item>> objectList = minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).build());
            Message message = MinioProducer.getMessageForResponse(exchange);
            message.setBody(objectList);
        }
    }

    private void createPresignedUrl(MinioClient minioClient, Exchange exchange, Method method) throws Exception {
        int expiry = 3600;
        Integer expirationInSeconds = exchange.getIn().getHeader("CamelMinioPresignedURLExpirationTime", Integer.class);
        Message message = MinioProducer.getMessageForResponse(exchange);
        if (expirationInSeconds != null) {
            expiry = expirationInSeconds;
        }
        if (this.getConfiguration().isPojoRequest()) {
            GetPresignedObjectUrlArgs.Builder payload = exchange.getIn().getMandatoryBody(GetPresignedObjectUrlArgs.Builder.class);
            if (ObjectHelper.isNotEmpty(payload)) {
                GetPresignedObjectUrlArgs args2 = (GetPresignedObjectUrlArgs)payload.expiry(expiry).method(method).build();
                String response = minioClient.getPresignedObjectUrl(args2);
                message.setBody(response);
            }
        } else {
            String bucketName = this.determineBucketName(exchange);
            String objectName = this.determineObjectName(exchange);
            GetPresignedObjectUrlArgs args3 = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).object(objectName)).expiry(expiry).method(method).build();
            String response = minioClient.getPresignedObjectUrl(args3);
            message.setBody(response);
        }
    }

    private MinioOperations determineOperation(Exchange exchange) {
        MinioOperations operation = exchange.getIn().getHeader("CamelMinioOperation", MinioOperations.class);
        if (ObjectHelper.isEmpty(operation)) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    private Map<String, String> determineMetadata(Exchange exchange) {
        String contentMD5;
        String contentEncoding;
        String contentDisposition;
        String cacheControl;
        String contentType;
        HashMap<String, String> objectMetadata = new HashMap<String, String>();
        Long contentLength = exchange.getIn().getHeader("CamelMinioContentLength", Long.class);
        if (ObjectHelper.isNotEmpty(contentLength)) {
            objectMetadata.put("Content-Length", String.valueOf(contentLength));
        }
        if (ObjectHelper.isNotEmpty(contentType = exchange.getIn().getHeader("CamelMinioContentType", String.class))) {
            objectMetadata.put("Content-Type", contentType);
        }
        if (ObjectHelper.isNotEmpty(cacheControl = exchange.getIn().getHeader("CamelMinioContentControl", String.class))) {
            objectMetadata.put("Cache-Control", cacheControl);
        }
        if (ObjectHelper.isNotEmpty(contentDisposition = exchange.getIn().getHeader("CamelMinioContentDisposition", String.class))) {
            objectMetadata.put("Content-Disposition", contentDisposition);
        }
        if (ObjectHelper.isNotEmpty(contentEncoding = exchange.getIn().getHeader("CamelMinioContentEncoding", String.class))) {
            objectMetadata.put("Content-Encoding", contentEncoding);
        }
        if (ObjectHelper.isNotEmpty(contentMD5 = exchange.getIn().getHeader("CamelMinioContentMD5", String.class))) {
            objectMetadata.put("Content-Md5", contentMD5);
        }
        return objectMetadata;
    }

    private String determineBucketName(Exchange exchange) {
        String bucketName = exchange.getIn().getHeader("CamelMinioBucketName", String.class);
        if (ObjectHelper.isEmpty(bucketName)) {
            if (ObjectHelper.isNotEmpty(this.getConfiguration().getBucketName())) {
                bucketName = this.getConfiguration().getBucketName();
                LOG.trace("Minio Bucket name header is missing, using default one {}", (Object)bucketName);
            } else {
                throw new IllegalArgumentException("Minio Bucket name header is missing or not configured.");
            }
        }
        return bucketName;
    }

    private String determineObjectName(Exchange exchange) {
        String objectName = exchange.getIn().getHeader("CamelMinioObjectName", String.class);
        if (ObjectHelper.isEmpty(objectName)) {
            objectName = this.getConfiguration().getKeyName();
        }
        if (ObjectHelper.isEmpty(objectName)) {
            throw new IllegalArgumentException("Minio Key header is missing.");
        }
        return objectName;
    }

    private String determineStorageClass(Exchange exchange) {
        String storageClass = exchange.getIn().getHeader("CamelMinioStorageClass", String.class);
        if (ObjectHelper.isEmpty(storageClass)) {
            storageClass = this.getConfiguration().getStorageClass();
        }
        return storageClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long determineLengthInputStream(InputStream is) throws IOException {
        if (!is.markSupported()) {
            return -1L;
        }
        if (is instanceof ByteArrayInputStream) {
            return is.available();
        }
        long size = 0L;
        try {
            is.mark(1024);
            int i = is.available();
            while (i > 0) {
                long skip = is.skip(i);
                size += skip;
                i = is.available();
            }
        }
        finally {
            is.reset();
        }
        return size;
    }

    protected MinioConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    @Override
    public MinioEndpoint getEndpoint() {
        return (MinioEndpoint)super.getEndpoint();
    }
}

