/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class MllpEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":hostname:port";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    @Override
    public boolean isEnabled(String scheme) {
        return "mllp".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "hostname", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(30);
        props.add("acceptTimeout");
        props.add("autoAck");
        props.add("backlog");
        props.add("bindRetryInterval");
        props.add("bindTimeout");
        props.add("bridgeErrorHandler");
        props.add("charsetName");
        props.add("connectTimeout");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("hl7Headers");
        props.add("hostname");
        props.add("idleTimeout");
        props.add("idleTimeoutStrategy");
        props.add("keepAlive");
        props.add("lazyStartProducer");
        props.add("lenientBind");
        props.add("maxBufferSize");
        props.add("maxConcurrentConsumers");
        props.add("minBufferSize");
        props.add("port");
        props.add("readTimeout");
        props.add("receiveBufferSize");
        props.add("receiveTimeout");
        props.add("requireEndOfData");
        props.add("reuseAddress");
        props.add("sendBufferSize");
        props.add("stringPayload");
        props.add("tcpNoDelay");
        props.add("validatePayload");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

