/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.internal;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import org.apache.camel.Route;
import org.apache.camel.component.mllp.MllpSocketException;
import org.apache.camel.component.mllp.MllpTcpServerConsumer;
import org.apache.camel.component.mllp.internal.MllpSocketBuffer;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TcpServerConsumerValidationRunnable
implements Runnable {
    final Socket clientSocket;
    final MllpSocketBuffer mllpBuffer;
    Logger log = LoggerFactory.getLogger(this.getClass());
    MllpTcpServerConsumer consumer;
    private final String localAddress;
    private final String remoteAddress;
    private final String combinedAddress;

    public TcpServerConsumerValidationRunnable(MllpTcpServerConsumer consumer, Socket clientSocket, MllpSocketBuffer mllpBuffer) {
        this.consumer = consumer;
        this.clientSocket = clientSocket;
        SocketAddress localSocketAddress = clientSocket.getLocalSocketAddress();
        this.localAddress = localSocketAddress != null ? localSocketAddress.toString() : null;
        SocketAddress remoteSocketAddress = clientSocket.getRemoteSocketAddress();
        this.remoteAddress = remoteSocketAddress != null ? remoteSocketAddress.toString() : null;
        this.combinedAddress = MllpSocketBuffer.formatAddressString(remoteSocketAddress, localSocketAddress);
        try {
            if (consumer.getConfiguration().hasKeepAlive()) {
                this.clientSocket.setKeepAlive(consumer.getConfiguration().getKeepAlive());
            }
            if (consumer.getConfiguration().hasTcpNoDelay()) {
                this.clientSocket.setTcpNoDelay(consumer.getConfiguration().getTcpNoDelay());
            }
            if (consumer.getConfiguration().hasReceiveBufferSize()) {
                this.clientSocket.setReceiveBufferSize(consumer.getConfiguration().getReceiveBufferSize());
            }
            if (consumer.getConfiguration().hasSendBufferSize()) {
                this.clientSocket.setSendBufferSize(consumer.getConfiguration().getSendBufferSize());
            }
            this.clientSocket.setSoLinger(false, -1);
            this.clientSocket.setSoTimeout(consumer.getConfiguration().getReceiveTimeout());
        }
        catch (IOException initializationException) {
            throw new IllegalStateException("Failed to initialize " + this.getClass().getSimpleName(), initializationException);
        }
        this.mllpBuffer = mllpBuffer == null ? new MllpSocketBuffer(consumer.getEndpoint()) : mllpBuffer;
    }

    String createThreadName() {
        String fullEndpointKey = this.consumer.getEndpoint().getEndpointKey();
        String endpointKey = StringHelper.before(fullEndpointKey, "?", fullEndpointKey);
        return String.format("%s[%s] - %s", this.getClass().getSimpleName(), endpointKey, this.combinedAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String routeId;
        String originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.createThreadName());
        MDC.put((String)"camel.contextId", (String)this.consumer.getEndpoint().getCamelContext().getName());
        Route route = this.consumer.getRoute();
        if (route != null && (routeId = route.getId()) != null) {
            MDC.put((String)"camel.routeId", (String)route.getId());
        }
        this.log.debug("Checking {} for data", (Object)this.combinedAddress);
        try {
            this.mllpBuffer.readFrom(this.clientSocket, Math.min(500, this.consumer.getConfiguration().getReceiveTimeout()), this.consumer.getConfiguration().getReadTimeout());
            if (this.mllpBuffer.hasCompleteEnvelope() || this.mllpBuffer.hasStartOfBlock()) {
                this.consumer.startConsumer(this.clientSocket, this.mllpBuffer);
            } else if (!this.mllpBuffer.isEmpty()) {
                this.log.info("Ignoring out-of-band data on initial read [{} bytes]: {}", (Object)this.mllpBuffer.size(), (Object)this.mllpBuffer.toPrintFriendlyStringAndReset());
                this.mllpBuffer.resetSocket(this.clientSocket);
            }
        }
        catch (MllpSocketException socketEx) {
            if (!this.mllpBuffer.isEmpty()) {
                this.log.warn("Exception encountered receiving complete initial message [{} bytes]: {}", (Object)this.mllpBuffer.size(), (Object)this.mllpBuffer.toPrintFriendlyStringAndReset());
            }
            this.mllpBuffer.resetSocket(this.clientSocket);
        }
        catch (SocketTimeoutException timeoutEx) {
            if (this.mllpBuffer.isEmpty()) {
                this.log.debug("Initial read timed-out but no data was read - starting consumer");
                this.consumer.startConsumer(this.clientSocket, this.mllpBuffer);
            } else {
                this.log.warn("Timeout receiving complete initial message on read [{} bytes]: {}", (Object)this.mllpBuffer.size(), (Object)this.mllpBuffer.toPrintFriendlyStringAndReset());
                this.mllpBuffer.resetSocket(this.clientSocket);
            }
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    public void closeSocket() {
        this.mllpBuffer.closeSocket(this.clientSocket);
    }

    public void closeSocket(String logMessage) {
        this.mllpBuffer.closeSocket(this.clientSocket, logMessage);
    }

    public void resetSocket() {
        this.mllpBuffer.resetSocket(this.clientSocket);
    }

    public void resetSocket(String logMessage) {
        this.mllpBuffer.resetSocket(this.clientSocket, logMessage);
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getCombinedAddress() {
        return this.combinedAddress;
    }
}

