/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.internal;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import org.apache.camel.Route;
import org.apache.camel.component.mllp.MllpSocketException;
import org.apache.camel.component.mllp.MllpTcpServerConsumer;
import org.apache.camel.component.mllp.internal.Hl7Util;
import org.apache.camel.component.mllp.internal.MllpSocketBuffer;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TcpSocketConsumerRunnable
implements Runnable {
    final Socket clientSocket;
    final MllpSocketBuffer mllpBuffer;
    Logger log = LoggerFactory.getLogger(this.getClass());
    MllpTcpServerConsumer consumer;
    boolean running;
    private final String localAddress;
    private final String remoteAddress;
    private final String combinedAddress;
    private final Hl7Util hl7Util;
    private final boolean logPhi;

    public TcpSocketConsumerRunnable(MllpTcpServerConsumer consumer, Socket clientSocket, MllpSocketBuffer mllpBuffer, Hl7Util hl7Util, boolean logPhi) {
        this.consumer = consumer;
        this.clientSocket = clientSocket;
        this.hl7Util = hl7Util;
        this.logPhi = logPhi;
        SocketAddress localSocketAddress = clientSocket.getLocalSocketAddress();
        this.localAddress = localSocketAddress != null ? localSocketAddress.toString() : null;
        SocketAddress remoteSocketAddress = clientSocket.getRemoteSocketAddress();
        this.remoteAddress = remoteSocketAddress != null ? remoteSocketAddress.toString() : null;
        this.combinedAddress = MllpSocketBuffer.formatAddressString(remoteSocketAddress, localSocketAddress);
        try {
            if (consumer.getConfiguration().hasKeepAlive()) {
                this.clientSocket.setKeepAlive(consumer.getConfiguration().getKeepAlive());
            }
            if (consumer.getConfiguration().hasTcpNoDelay()) {
                this.clientSocket.setTcpNoDelay(consumer.getConfiguration().getTcpNoDelay());
            }
            if (consumer.getConfiguration().hasReceiveBufferSize()) {
                this.clientSocket.setReceiveBufferSize(consumer.getConfiguration().getReceiveBufferSize());
            }
            if (consumer.getConfiguration().hasSendBufferSize()) {
                this.clientSocket.setSendBufferSize(consumer.getConfiguration().getSendBufferSize());
            }
            this.clientSocket.setSoLinger(false, -1);
            this.clientSocket.setSoTimeout(consumer.getConfiguration().getReceiveTimeout());
        }
        catch (IOException initializationException) {
            throw new IllegalStateException("Failed to initialize " + this.getClass().getSimpleName(), initializationException);
        }
        this.mllpBuffer = mllpBuffer == null ? new MllpSocketBuffer(consumer.getEndpoint()) : mllpBuffer;
    }

    String createThreadName() {
        String fullEndpointKey = this.consumer.getEndpoint().getEndpointKey();
        String endpointKey = StringHelper.before(fullEndpointKey, "?", fullEndpointKey);
        return String.format("%s[%s] - %s", this.getClass().getSimpleName(), endpointKey, this.combinedAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String routeId;
        this.running = true;
        String originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.createThreadName());
        MDC.put((String)"camel.contextId", (String)this.consumer.getEndpoint().getCamelContext().getName());
        Route route = this.consumer.getRoute();
        if (route != null && (routeId = route.getId()) != null) {
            MDC.put((String)"camel.routeId", (String)route.getId());
        }
        this.log.debug("Starting {} for {}", (Object)this.getClass().getSimpleName(), (Object)this.combinedAddress);
        try {
            byte[] hl7MessageBytes = null;
            if (this.mllpBuffer.hasCompleteEnvelope()) {
                hl7MessageBytes = this.mllpBuffer.toMllpPayload();
                this.mllpBuffer.reset();
                this.consumer.processMessage(hl7MessageBytes, this);
            }
            while (this.running && null != this.clientSocket && this.clientSocket.isConnected() && !this.clientSocket.isClosed()) {
                this.log.debug("Checking for data ....");
                try {
                    byte[] payload;
                    this.mllpBuffer.readFrom(this.clientSocket);
                    if (this.mllpBuffer.hasCompleteEnvelope()) {
                        hl7MessageBytes = this.mllpBuffer.toMllpPayload();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Received {} byte message {}", (Object)hl7MessageBytes.length, (Object)this.hl7Util.convertToPrintFriendlyString(hl7MessageBytes));
                        }
                        if (this.mllpBuffer.hasLeadingOutOfBandData()) {
                            this.log.warn("Ignoring leading out-of-band data: {}", (Object)this.hl7Util.convertToPrintFriendlyString(this.mllpBuffer.getLeadingOutOfBandData()));
                        }
                        if (this.mllpBuffer.hasTrailingOutOfBandData()) {
                            this.log.warn("Ignoring trailing out-of-band data: {}", (Object)this.hl7Util.convertToPrintFriendlyString(this.mllpBuffer.getTrailingOutOfBandData()));
                        }
                        this.mllpBuffer.reset();
                        this.consumer.processMessage(hl7MessageBytes, this);
                        continue;
                    }
                    if (!this.mllpBuffer.hasStartOfBlock()) {
                        payload = this.mllpBuffer.toByteArray();
                        this.log.warn("Ignoring {} byte un-enveloped payload {}", (Object)payload.length, (Object)this.hl7Util.convertToPrintFriendlyString(payload));
                        this.mllpBuffer.reset();
                        continue;
                    }
                    if (this.mllpBuffer.isEmpty()) continue;
                    payload = this.mllpBuffer.toByteArray();
                    this.log.warn("Partial {} byte payload received {}", (Object)payload.length, (Object)this.hl7Util.convertToPrintFriendlyString(payload));
                }
                catch (SocketTimeoutException timeoutEx) {
                    if (this.mllpBuffer.isEmpty()) {
                        long lastReceivedMessageTicks;
                        long currentTicks;
                        long idleTime;
                        if (this.consumer.getConfiguration().hasIdleTimeout() && (idleTime = (currentTicks = System.currentTimeMillis()) - (lastReceivedMessageTicks = this.consumer.getConsumerRunnables().get(this).longValue())) >= (long)this.consumer.getConfiguration().getIdleTimeout().intValue()) {
                            String resetMessage = String.format("Connection idle time %d exceeded idleTimeout %d", idleTime, this.consumer.getConfiguration().getIdleTimeout());
                            this.mllpBuffer.resetSocket(this.clientSocket, resetMessage);
                        }
                        this.log.debug("No data received - ignoring timeout");
                        continue;
                    }
                    this.mllpBuffer.resetSocket(this.clientSocket);
                    this.consumer.handleMessageTimeout("Timeout receiving complete message payload", this.mllpBuffer.toByteArrayAndReset(), timeoutEx);
                }
                catch (MllpSocketException mllpSocketEx) {
                    this.mllpBuffer.resetSocket(this.clientSocket);
                    if (!this.mllpBuffer.isEmpty()) {
                        this.consumer.handleMessageException("Exception encountered reading payload", this.mllpBuffer.toByteArrayAndReset(), mllpSocketEx);
                        continue;
                    }
                    this.log.debug("Ignoring exception encountered checking for data", (Throwable)mllpSocketEx);
                }
            }
        }
        catch (Exception unexpectedEx) {
            this.log.error("Unexpected exception encountered receiving messages", (Throwable)unexpectedEx);
        }
        finally {
            this.consumer.getConsumerRunnables().remove(this);
            this.log.debug("{} for {} completed", (Object)this.getClass().getSimpleName(), (Object)this.combinedAddress);
            Thread.currentThread().setName(originalThreadName);
            MDC.remove((String)"camel.routeId");
            MDC.remove((String)"camel.contextId");
            this.mllpBuffer.resetSocket(this.clientSocket);
        }
    }

    public Socket getSocket() {
        return this.clientSocket;
    }

    public MllpSocketBuffer getMllpBuffer() {
        return this.mllpBuffer;
    }

    public void closeSocket() {
        this.mllpBuffer.closeSocket(this.clientSocket);
    }

    public void closeSocket(String logMessage) {
        this.mllpBuffer.closeSocket(this.clientSocket, logMessage);
    }

    public void resetSocket() {
        this.mllpBuffer.resetSocket(this.clientSocket);
    }

    public void resetSocket(String logMessage) {
        this.mllpBuffer.resetSocket(this.clientSocket, logMessage);
    }

    public void stop() {
        this.running = false;
    }

    public boolean hasLocalAddress() {
        return this.localAddress != null && !this.localAddress.isEmpty();
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public boolean hasRemoteAddress() {
        return this.remoteAddress != null && !this.remoteAddress.isEmpty();
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public boolean hasCombinedAddress() {
        return this.combinedAddress != null && this.combinedAddress.isEmpty();
    }

    public String getCombinedAddress() {
        return this.combinedAddress;
    }
}

