/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.api.ClusterInfo;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.SequenceInfo;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.Duration;
import java.time.ZonedDateTime;

public class ConsumerInfo
extends ApiResponse<ConsumerInfo> {
    private final String stream;
    private final String name;
    private final ConsumerConfiguration configuration;
    private final ZonedDateTime created;
    private final SequenceInfo delivered;
    private final SequenceInfo ackFloor;
    private final long numPending;
    private final long numWaiting;
    private final long numAckPending;
    private final long numRedelivered;
    private final boolean paused;
    private final Duration pauseRemaining;
    private final ClusterInfo clusterInfo;
    private final boolean pushBound;
    private final ZonedDateTime timestamp;

    public ConsumerInfo(Message msg) {
        this(ConsumerInfo.parseMessage(msg));
    }

    public ConsumerInfo(JsonValue vConsumerInfo) {
        super(vConsumerInfo);
        this.configuration = ConsumerConfiguration.builder().jsonValue(JsonValueUtils.readObject(this.jv, "config")).build();
        this.stream = JsonValueUtils.readString(this.jv, "stream_name");
        this.name = JsonValueUtils.readString(this.jv, "name");
        this.created = JsonValueUtils.readDate(this.jv, "created");
        this.delivered = new SequenceInfo(JsonValueUtils.readObject(this.jv, "delivered"));
        this.ackFloor = new SequenceInfo(JsonValueUtils.readObject(this.jv, "ack_floor"));
        this.numAckPending = JsonValueUtils.readLong(this.jv, "num_ack_pending", 0L);
        this.numRedelivered = JsonValueUtils.readLong(this.jv, "num_redelivered", 0L);
        this.numPending = JsonValueUtils.readLong(this.jv, "num_pending", 0L);
        this.numWaiting = JsonValueUtils.readLong(this.jv, "num_waiting", 0L);
        this.paused = JsonValueUtils.readBoolean(this.jv, "paused", false);
        this.pauseRemaining = JsonValueUtils.readNanos(this.jv, "pause_remaining");
        this.clusterInfo = ClusterInfo.optionalInstance(JsonValueUtils.readValue(this.jv, "cluster"));
        this.pushBound = JsonValueUtils.readBoolean(this.jv, "push_bound");
        this.timestamp = JsonValueUtils.readDate(this.jv, "ts");
    }

    public ConsumerConfiguration getConsumerConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public String getStreamName() {
        return this.stream;
    }

    public ZonedDateTime getCreationTime() {
        return this.created;
    }

    public SequenceInfo getDelivered() {
        return this.delivered;
    }

    public SequenceInfo getAckFloor() {
        return this.ackFloor;
    }

    public long getNumPending() {
        return this.numPending;
    }

    public long getNumWaiting() {
        return this.numWaiting;
    }

    public long getNumAckPending() {
        return this.numAckPending;
    }

    public long getRedelivered() {
        return this.numRedelivered;
    }

    public boolean getPaused() {
        return this.paused;
    }

    public Duration getPauseRemaining() {
        return this.pauseRemaining;
    }

    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public boolean isPushBound() {
        return this.pushBound;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public long getCalculatedPending() {
        return this.numPending + this.delivered.getConsumerSequence();
    }
}

