/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.digests.KeccakDigest;
import org.bouncycastle.crypto.digests.SHA3NativeDigest;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public class SHA3Digest
extends KeccakDigest
implements SavableDigest {
    private static int checkBitLength(int n) {
        switch (n) {
            case 224: 
            case 256: 
            case 384: 
            case 512: {
                return n;
            }
        }
        throw new IllegalArgumentException("'bitLength' " + n + " not supported for SHA-3");
    }

    public static SavableDigest newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("SHA3")) {
            return new SHA3NativeDigest();
        }
        return new SHA3Digest();
    }

    public SHA3Digest() {
        this(256, CryptoServicePurpose.ANY);
    }

    public static SavableDigest newInstance(CryptoServicePurpose cryptoServicePurpose) {
        if (CryptoServicesRegistrar.hasEnabledService("SHA3")) {
            return new SHA3NativeDigest(cryptoServicePurpose);
        }
        return new SHA3Digest(cryptoServicePurpose);
    }

    public SHA3Digest(CryptoServicePurpose cryptoServicePurpose) {
        this(256, cryptoServicePurpose);
    }

    public static SavableDigest newInstance(int n) {
        if (CryptoServicesRegistrar.hasEnabledService("SHA3")) {
            return new SHA3NativeDigest(n);
        }
        return new SHA3Digest(n);
    }

    public SHA3Digest(int n) {
        super(SHA3Digest.checkBitLength(n), CryptoServicePurpose.ANY);
    }

    public static SavableDigest newInstance(int n, CryptoServicePurpose cryptoServicePurpose) {
        if (CryptoServicesRegistrar.hasEnabledService("SHA3")) {
            return new SHA3NativeDigest(n, cryptoServicePurpose);
        }
        return new SHA3Digest(n, cryptoServicePurpose);
    }

    public SHA3Digest(int n, CryptoServicePurpose cryptoServicePurpose) {
        super(SHA3Digest.checkBitLength(n), cryptoServicePurpose);
    }

    public static SavableDigest newInstance(Digest digest) {
        if (CryptoServicesRegistrar.hasEnabledService("SHA3") && digest instanceof SHA3NativeDigest) {
            return new SHA3NativeDigest((SHA3NativeDigest)digest);
        }
        return new SHA3Digest((SHA3Digest)digest);
    }

    public SHA3Digest(SHA3Digest sHA3Digest) {
        super(sHA3Digest);
    }

    public SHA3Digest(byte[] byArray) {
        if (byArray.length != 13 + this.state.length * 8) {
            throw new IllegalArgumentException("encoded state has incorrect length");
        }
        this.bitsInQueue = Pack.bigEndianToInt(byArray, 0);
        this.rate = Pack.bigEndianToInt(byArray, 4);
        this.squeezing = Integer.MAX_VALUE == Pack.bigEndianToInt(byArray, 8);
        this.fixedOutputLength = Pack.bigEndianToInt(byArray, 12);
        int n = 16;
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = Pack.bigEndianToInt(byArray, n += 8);
        }
        this.purpose = CryptoServicePurpose.values()[byArray[n]];
    }

    public static SavableDigest newInstance(byte[] byArray, CryptoServicePurpose cryptoServicePurpose) {
        if (CryptoServicesRegistrar.hasEnabledService("SHA3")) {
            return new SHA3NativeDigest(byArray, cryptoServicePurpose);
        }
        return new SHA3Digest(byArray, cryptoServicePurpose);
    }

    public SHA3Digest(byte[] byArray, CryptoServicePurpose cryptoServicePurpose) {
        this(byArray);
        this.purpose = cryptoServicePurpose;
    }

    @Override
    public String getAlgorithmName() {
        return "SHA3-" + this.fixedOutputLength;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        this.absorbBits(2, 2);
        return super.doFinal(byArray, n);
    }

    @Override
    protected int doFinal(byte[] byArray, int n, byte by, int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int n3 = by & (1 << n2) - 1 | 2 << n2;
        int n4 = n2 + 2;
        if (n4 >= 8) {
            this.absorb((byte)n3);
            n4 -= 8;
            n3 >>>= 8;
        }
        return super.doFinal(byArray, n, (byte)n3, n4);
    }

    @Override
    public byte[] getEncodedState() {
        byte[] byArray = new byte[13 + this.state.length * 8];
        Pack.intToBigEndian(this.bitsInQueue, byArray, 0);
        Pack.intToBigEndian(this.rate, byArray, 4);
        Pack.intToBigEndian(this.squeezing ? Integer.MIN_VALUE : 0, byArray, 8);
        Pack.intToBigEndian(this.fixedOutputLength, byArray, 12);
        int n = 16;
        for (long l : this.state) {
            Pack.longToBigEndian(l, byArray, n += 8);
        }
        this.state[this.state.length - 1] = (byte)this.purpose.ordinal();
        return byArray;
    }

    @Override
    public Memoable copy() {
        return new SHA3Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        if (!(memoable instanceof SHA3Digest)) {
            throw new IllegalArgumentException("no SHA3Digest instance");
        }
        this.bitsInQueue = ((SHA3Digest)memoable).bitsInQueue;
        this.rate = ((SHA3Digest)memoable).rate;
        this.squeezing = ((SHA3Digest)memoable).squeezing;
        this.fixedOutputLength = ((SHA3Digest)memoable).fixedOutputLength;
        System.arraycopy(((SHA3Digest)memoable).state, 0, this.state, 0, this.state.length);
        this.purpose = ((SHA3Digest)memoable).purpose;
    }

    public String toString() {
        return "SHA3[Java]";
    }
}

