/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

class SHA512NativeDigest
implements SavableDigest {
    private final CryptoServicePurpose purpose;
    protected DigestRefWrapper nativeRef = null;

    SHA512NativeDigest(CryptoServicePurpose cryptoServicePurpose) {
        this.purpose = cryptoServicePurpose;
        this.nativeRef = new DigestRefWrapper(SHA512NativeDigest.makeNative());
        this.reset();
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    SHA512NativeDigest() {
        this(CryptoServicePurpose.ANY);
    }

    SHA512NativeDigest(SHA512NativeDigest sHA512NativeDigest) {
        this(CryptoServicePurpose.ANY);
        byte[] byArray = sHA512NativeDigest.getEncodedState();
        SHA512NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    SHA512NativeDigest restoreState(byte[] byArray, int n) {
        SHA512NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-512";
    }

    @Override
    public int getDigestSize() {
        return SHA512NativeDigest.getDigestSize(this.nativeRef.getReference());
    }

    @Override
    public void update(byte by) {
        SHA512NativeDigest.update(this.nativeRef.getReference(), by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        SHA512NativeDigest.update(this.nativeRef.getReference(), byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        return SHA512NativeDigest.doFinal(this.nativeRef.getReference(), byArray, n);
    }

    @Override
    public void reset() {
        SHA512NativeDigest.reset(this.nativeRef.getReference());
    }

    @Override
    public int getByteLength() {
        return SHA512NativeDigest.getByteLength(this.nativeRef.getReference());
    }

    @Override
    public Memoable copy() {
        return new SHA512NativeDigest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SHA512NativeDigest sHA512NativeDigest = (SHA512NativeDigest)memoable;
        SHA512NativeDigest.restoreFullState(this.nativeRef.getReference(), sHA512NativeDigest.getEncodedState(), 0);
    }

    @Override
    public byte[] getEncodedState() {
        int n = SHA512NativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
        byte[] byArray = new byte[n];
        SHA512NativeDigest.encodeFullState(this.nativeRef.getReference(), byArray, 0);
        return byArray;
    }

    void restoreFullState(byte[] byArray, int n) {
        SHA512NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
    }

    public String toString() {
        return "SHA512[Native]()";
    }

    static native long makeNative();

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, 512, this.purpose);
    }

    private static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long l) {
            super(l, "SHA512");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            SHA512NativeDigest.destroy(l);
        }
    }
}

